/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp;

import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.helper.IOUtil;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletPreferencesImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.persistenceImp.PersistenceManager;

public class DefaultPersistenceManager
implements PersistenceManager {
    private final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    protected ExoContainer cont;

    public DefaultPersistenceManager(ExoContainerContext context) throws Exception {
        this.cont = context.getContainer();
    }

    public final PortletWindowInternal getWindow(Input input, ExoPortletPreferences defaultPrefs) {
        WindowID windowID = input.getInternalWindowID();
        String validatorClassName = null;
        PreferencesValidator validator = null;
        if (defaultPrefs != null && (validatorClassName = defaultPrefs.getPreferencesValidator()) != null) {
            PortletApplicationProxy proxy = (PortletApplicationProxy)this.cont.getComponentInstance((Object)(windowID.getPortletApplicationName() + "_portlet_app_"));
            validator = proxy.getValidator(validatorClassName, windowID.getPortletName());
        }
        PortletPreferences prefsImp = null;
        if (!input.isStateSaveOnClient()) {
            PortletPreferencesPersister persister = null;
            persister = input.getPortletPreferencesPersister() != null ? input.getPortletPreferencesPersister() : (PortletPreferencesPersister)this.cont.getComponentInstanceOfType(PortletPreferencesPersister.class);
            try {
                ExoPortletPreferences currentPreferences = persister.getPortletPreferences(windowID);
                prefsImp = new PortletPreferencesImp(validator, defaultPrefs, windowID, persister);
                if (currentPreferences != null) {
                    ((PortletPreferencesImp)prefsImp).setCurrentPreferences(currentPreferences);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Error: ", (Throwable)ex);
            }
        } else {
            byte[] portletState = input.getPortletState();
            if (portletState != null) {
                try {
                    prefsImp = (PortletPreferences)IOUtil.deserialize((byte[])portletState);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error: ", (Throwable)e);
                }
            }
        }
        return new PortletWindowInternal(windowID, prefsImp);
    }
}

