/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.CacheControlImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletURLImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceURLImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeResponseImp
extends PortletResponseImp
implements MimeResponse {
    private final Collection<String> supportedContents_;
    private String contentType_;
    private boolean writerAlreadyCalled_;
    private boolean outputStreamAlreadyCalled_;
    private final CacheControlImp cacheCtl;
    private boolean committed;

    public MimeResponseImp(ResponseContext resCtx) {
        super(resCtx);
        this.supportedContents_ = resCtx.getSupportedContents();
        this.writerAlreadyCalled_ = false;
        this.outputStreamAlreadyCalled_ = false;
        this.cacheCtl = new CacheControlImp(this);
        this.committed = false;
    }

    public String getContentType() {
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            return null;
        }
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        if (this.committed) {
            throw new IllegalStateException("the response has already been committed");
        }
        if (contentType != null) {
            contentType = StringUtils.split((String)contentType, (char)';')[0];
        }
        if (!this.isContentTypeSupported(contentType)) {
            throw new IllegalArgumentException("the content type : " + contentType + " is not supported.");
        }
        this.contentType_ = contentType;
        if (this.getOutput() instanceof RenderOutput) {
            ((RenderOutput)this.getOutput()).setContentType(this.contentType_);
        }
        if (this.getOutput() instanceof ResourceOutput) {
            ((ResourceOutput)this.getOutput()).setContentType(this.contentType_);
        }
    }

    public OutputStream getPortletOutputStream() throws IOException {
        if (this.isAlreadyForwarded()) {
            throw new IllegalStateException("response has already been forwarded");
        }
        if (this.writerAlreadyCalled_) {
            throw new IllegalStateException("getWriter() has already been called");
        }
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            throw new IllegalStateException("the content type has not been set before calling thegetPortletOutputStream() method.");
        }
        this.outputStreamAlreadyCalled_ = true;
        return super.getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.isAlreadyForwarded()) {
            throw new IllegalStateException("response has already been forwarded");
        }
        if (this.outputStreamAlreadyCalled_) {
            throw new IllegalStateException("the getPortletOutputStream object has already been called");
        }
        if (this.contentType_ == null || "".equals(this.contentType_)) {
            throw new IllegalStateException("the content type has not been set before calling thegetWriter() method.");
        }
        this.writerAlreadyCalled_ = true;
        return super.getWriter();
    }

    private boolean isContentTypeSupported(String contentTypeToTest) {
        Collection<String> c = this.getResponseContentTypes();
        for (String element : c) {
            if (!element.equals(contentTypeToTest)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getResponseContentTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getResponseContentType());
        for (String element : this.supportedContents_) {
            List l = this.getPortletDatas().getSupports();
            block1: for (int i = 0; i < l.size(); ++i) {
                Supports supportsType = (Supports)l.get(i);
                String mimeType = supportsType.getMimeType();
                if (!element.equals(mimeType) || element.equals(this.getInput().getMarkup())) continue;
                List portletModes = supportsType.getPortletMode();
                for (String portletMode : portletModes) {
                    if (!portletMode.equals(this.getInput().getPortletMode().toString())) continue;
                    result.add(mimeType);
                    continue block1;
                }
            }
        }
        return result;
    }

    private String getResponseContentType() {
        List l = this.getPortletDatas().getSupports();
        for (int i = 0; i < l.size(); ++i) {
            Supports supportsType = (Supports)l.get(i);
            String mimeType = supportsType.getMimeType();
            if (!mimeType.equals(this.getInput().getMarkup())) continue;
            List portletModes = supportsType.getPortletMode();
            for (String portletMode : portletModes) {
                if (!portletMode.equals(this.getInput().getPortletMode().toString())) continue;
                return mimeType;
            }
        }
        return "text/html";
    }

    public void flushBuffer() throws IOException {
        this.committed = true;
    }

    public int getBufferSize() {
        return 0;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public Locale getLocale() {
        Locale l = super.getLocale();
        if (l == null) {
            return new Locale("en");
        }
        return l;
    }

    public CacheControl getCacheControl() {
        return this.cacheCtl;
    }

    public PortletURL createActionURL() throws IllegalStateException {
        if (this.getInput() instanceof ResourceInput && !"cacheLevelPage".equalsIgnoreCase(((ResourceInput)this.getInput()).getCacheability())) {
            throw new IllegalStateException("Cannot create action URL from within serveResource() without PAGE Cacheability");
        }
        if (this.getInput().getPortletURLFactory() != null) {
            return this.getInput().getPortletURLFactory().createPortletURL("action");
        }
        return new PortletURLImp("action", this.getInput().getBaseURL(), this.getInput().getMarkup(), this.getPortletDatas().getSupports(), this.isCurrentlySecured(), this.getInput().getEscapeXml(), this.getPortletDatas());
    }

    public ResourceURL createResourceURL() throws IllegalStateException {
        String originalCacheLevel = null;
        if (this.getInput() instanceof ResourceInput) {
            originalCacheLevel = ((ResourceInput)this.getInput()).getCacheability();
        }
        if (this.getInput().getPortletURLFactory() != null) {
            return this.getInput().getPortletURLFactory().createResourceURL("resource");
        }
        return new ResourceURLImp("resource", this.getInput().getBaseURL(), this.isCurrentlySecured(), this.getInput().getEscapeXml(), originalCacheLevel, this.getPortletDatas(), this.getInput().getRenderParameters());
    }
}

