/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPHttpServletRequest
extends HttpServletRequestWrapper
implements HttpServletRequest {
    protected HttpSession wsrpSession;
    protected Map<String, String[]> parameters;

    public WSRPHttpServletRequest(HttpServletRequest request) {
        super(request);
        this.wsrpSession = new WSRPHttpSession(request.getSession());
        this.parameters = new HashMap<String, String[]>();
    }

    public HttpSession getSession(boolean create) {
        if (this.wsrpSession == null && create) {
            this.wsrpSession = new WSRPHttpSession();
        }
        return this.wsrpSession;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public void setWsrpSession(WSRPHttpSession wsrpSession) {
        this.wsrpSession = wsrpSession;
    }

    public String getParameter(String name) {
        if (this.parameters.get(name) == null) {
            return super.getParameter(name);
        }
        return this.parameters.get(name)[0];
    }

    public Enumeration<String> getParameterNames() {
        Enumeration supernames = super.getParameterNames();
        Set<String> thisnames = this.parameters.keySet();
        HashSet<String> result = new HashSet<String>(thisnames);
        while (supernames.hasMoreElements()) {
            String elem = (String)supernames.nextElement();
            result.add(elem);
        }
        return Collections.enumeration(result);
    }

    public String[] getParameterValues(String name) {
        HashSet<Object> result = null;
        String[] supervaluesarr = super.getParameterValues(name);
        if (supervaluesarr != null) {
            List<String> supervaluescoll = Arrays.asList(supervaluesarr);
            result = new HashSet<String>(supervaluescoll);
        } else {
            result = new HashSet();
        }
        String[] thisvalues = this.parameters.get(name);
        if (thisvalues != null) {
            for (String value : thisvalues) {
                if (value == null) continue;
                result.add(value);
            }
        }
        return result.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameter(String key, String value) {
        String[] valueArray = new String[]{value};
        this.parameters.put(key, valueArray);
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}

