/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.impl.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.services.wsrp.consumer.GroupSession;
import org.exoplatform.services.wsrp.consumer.GroupSessionMgr;
import org.exoplatform.services.wsrp.consumer.UserSessionMgr;
import org.exoplatform.services.wsrp.consumer.impl.helpers.GroupSessionImpl;
import org.exoplatform.services.wsrp.consumer.impl.helpers.InitCookieImpl;
import org.exoplatform.services.wsrp.exceptions.WSRPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserSessionImpl
extends InitCookieImpl
implements UserSessionMgr {
    protected Map<String, GroupSession> groupSessions = new HashMap<String, GroupSession>();
    private String userID;

    public UserSessionImpl(String markupInterfaceURL) {
        super(markupInterfaceURL);
    }

    @Override
    public GroupSessionMgr getGroupSession(String groupID) throws WSRPException {
        if (groupID != null) {
            GroupSessionMgr groupSession = (GroupSessionMgr)this.groupSessions.get(groupID);
            if (groupSession == null) {
                groupSession = new GroupSessionImpl(groupID, this.getMarkupInterfaceURL());
                this.addGroupSession(groupSession);
            }
            return groupSession;
        }
        return null;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.userID = userID;
    }

    @Override
    public Iterator<GroupSession> getAllGroupSessions() {
        return this.groupSessions.values().iterator();
    }

    @Override
    public void addGroupSession(GroupSession groupSession) {
        this.groupSessions.put(groupSession.getGroupID(), groupSession);
    }

    @Override
    public void removeGroupSession(String groupID) {
        this.groupSessions.remove(groupID);
    }

    @Override
    public void removeAllGroupSessions() {
        this.groupSessions.clear();
    }
}

