/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.EventImpl;
import org.exoplatform.services.wsrp2.type.EventPayload;
import org.exoplatform.services.wsrp2.utils.StandardClasses;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBEventTransformer {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2.utils.JAXBEventTransformer");

    public static org.exoplatform.services.wsrp2.type.Event[] getEventsMarshal(Event event) {
        return new org.exoplatform.services.wsrp2.type.Event[]{JAXBEventTransformer.getEventMarshal(event)};
    }

    public static org.exoplatform.services.wsrp2.type.Event[] getEventsMarshal(List<Event> eventsList) {
        org.exoplatform.services.wsrp2.type.Event[] events = new org.exoplatform.services.wsrp2.type.Event[eventsList.size()];
        int i = 0;
        for (Event event : eventsList) {
            events[i++] = JAXBEventTransformer.getEventMarshal(event);
        }
        return events;
    }

    public static org.exoplatform.services.wsrp2.type.Event getEventMarshal(Event event) {
        if (event == null) {
            return null;
        }
        QName eventName = event.getQName();
        Serializable eventValue = event.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getEventMarshal() eventName = " + eventName));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getEventMarshal() eventValue = " + eventValue));
        }
        org.exoplatform.services.wsrp2.type.Event newEvent = new org.exoplatform.services.wsrp2.type.Event();
        newEvent.setName(eventName);
        if (eventValue != null) {
            String eventType = eventValue.getClass().getName();
            newEvent.setType(new QName(eventType));
            Document doc = JAXBEventTransformer.getMarshalledDocument(eventValue, eventName);
            if (doc == null) {
                try {
                    doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{eventValue.getClass()});
                    Marshaller marshaller = jaxb.createMarshaller();
                    marshaller.marshal((Object)eventValue, (Node)doc);
                }
                catch (JAXBException je) {
                    je.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            MessageElement messageElement = new MessageElement(doc.getDocumentElement());
            MessageElement[] anyArray = new MessageElement[]{messageElement};
            EventPayload eventPayload = new EventPayload();
            eventPayload.set_any(anyArray);
            newEvent.setPayload(eventPayload);
        }
        return newEvent;
    }

    public static List<Event> getEventsUnmarshal(org.exoplatform.services.wsrp2.type.Event[] eventArray) {
        if (eventArray == null) {
            return null;
        }
        ArrayList<Event> eventsList = new ArrayList<Event>();
        int i = 0;
        for (org.exoplatform.services.wsrp2.type.Event event : eventArray) {
            Object obj = JAXBEventTransformer.getUnmarshalledObject(event.getType(), event.getPayload());
            if (obj == null) {
                try {
                    String clazz = event.getType().getLocalPart();
                    String pkg = clazz.substring(0, clazz.lastIndexOf("."));
                    ClassLoader cle = Thread.currentThread().getContextClassLoader();
                    MessageElement messageElement = event.getPayload().get_any()[0];
                    JAXBContext jaxb = JAXBContext.newInstance((String)pkg, (ClassLoader)cle);
                    Unmarshaller unmarshaller = jaxb.createUnmarshaller();
                    obj = unmarshaller.unmarshal((Node)messageElement);
                }
                catch (JAXBException je) {
                    je.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getEventsUnmarshal() o = " + obj));
            }
            EventImpl ev = new EventImpl(event.getName(), obj != null ? (Serializable)obj : null);
            eventsList.add((Event)ev);
            ++i;
        }
        return eventsList;
    }

    public static Document getMarshalledDocument(Object value, QName name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() value = " + value));
        }
        try {
            String toenum = value.getClass().getSimpleName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() toenum = " + toenum));
            }
            StandardClasses t = null;
            try {
                t = StandardClasses.valueOf(toenum.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() t = " + (Object)((Object)t)));
            }
            return t.getMarshalledDocument(value, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getUnmarshalledObject(QName type, EventPayload payload) {
        try {
            String source = type.getLocalPart();
            String toenum = source.substring(source.lastIndexOf(".") + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getUnmarshalledObject() toenum = " + toenum));
            }
            StandardClasses t = null;
            try {
                t = StandardClasses.valueOf(toenum.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getUnmarshalledObject() t = " + (Object)((Object)t)));
            }
            return t.getUnmarshalledObject(type, payload);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

