/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl.helpers;

import java.rmi.RemoteException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.wsrp2.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp2.producer.RegistrationOperationsInterface;
import org.exoplatform.services.wsrp2.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp2.type.GetPortletsLifetimeResponse;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.PortletLifetime;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.UserContext;

public class Helper {
    private static ExoContainer cont = ExoContainerContext.getCurrentContainer();
    private static WSRPConfiguration conf = (WSRPConfiguration)cont.getComponentInstanceOfType(WSRPConfiguration.class);

    public static boolean checkLifetime(RegistrationContext registrationContext, UserContext userContext) {
        if (registrationContext == null) {
            return true;
        }
        RegistrationOperationsInterface roi = (RegistrationOperationsInterface)cont.getComponentInstanceOfType(RegistrationOperationsInterface.class);
        try {
            Lifetime lf = roi.getRegistrationLifetime(registrationContext, userContext);
            if (lf != null && Helper.lifetimeExpired(lf)) {
                roi.deregister(registrationContext, userContext);
                return false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean lifetimeExpired(Lifetime lf) {
        if (lf != null) {
            return lf.getTerminationTime().getTimeInMillis() < lf.getCurrentTime().getTimeInMillis();
        }
        return false;
    }

    public static boolean checkPortletLifetime(RegistrationContext registrationContext, PortletContext[] portletContexts, UserContext userContext, PortletManagementOperationsInterface pmoi) {
        if (registrationContext == null) {
            return true;
        }
        try {
            PortletLifetime plf;
            Lifetime lf;
            GetPortletsLifetimeResponse resp = pmoi.getPortletsLifetime(registrationContext, portletContexts, userContext);
            if (resp != null && resp.getPortletLifetime() != null && resp.getPortletLifetime().length != 0 && (lf = (plf = resp.getPortletLifetime(0)).getScheduledDestruction()) != null && Helper.lifetimeExpired(lf)) {
                String portletHandle = portletContexts[0].getPortletHandle();
                pmoi.destroyPortlets(registrationContext, new String[]{portletHandle}, userContext);
                return false;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void checkRegistrationContext(RegistrationContext registrationContext) throws RemoteException {
        if (conf.isRegistrationRequired() && registrationContext == null) {
            Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
        }
    }
}

