/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.ws.security.WSPasswordCallback;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wsrp2.AdminClient;

public class PasswordHandler
implements CallbackHandler {
    private static final Log LOG = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2.security.PasswordHandler");

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String username = pc.getIdentifier();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The username is '" + username + "'."));
                }
                String password = null;
                if (AdminClient.getPassword() != null) {
                    password = AdminClient.getPassword();
                } else {
                    try {
                        ExoContainer container = ExoContainerContext.getCurrentContainerIfPresent();
                        OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                        User user = orgService.getUserHandler().findUserByName(username);
                        password = user.getPassword();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Can't get the organization service, user and his password", (Throwable)e);
                    }
                }
                if (password == null) continue;
                pc.setPassword(password);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

