/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.exceptions;

import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.XMLUtils;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.type.AccessDeniedFault;
import org.exoplatform.services.wsrp2.type.Fault;
import org.exoplatform.services.wsrp2.type.InconsistentParametersFault;
import org.exoplatform.services.wsrp2.type.InvalidCookieFault;
import org.exoplatform.services.wsrp2.type.InvalidHandleFault;
import org.exoplatform.services.wsrp2.type.InvalidRegistrationFault;
import org.exoplatform.services.wsrp2.type.InvalidSessionFault;
import org.exoplatform.services.wsrp2.type.InvalidUserCategoryFault;
import org.exoplatform.services.wsrp2.type.MissingParametersFault;
import org.exoplatform.services.wsrp2.type.OperationFailedFault;
import org.exoplatform.services.wsrp2.type.PortletStateChangeRequiredFault;
import org.exoplatform.services.wsrp2.type.UnsupportedLocaleFault;
import org.exoplatform.services.wsrp2.type.UnsupportedMimeTypeFault;
import org.exoplatform.services.wsrp2.type.UnsupportedModeFault;
import org.exoplatform.services.wsrp2.type.UnsupportedWindowStateFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Exception2Fault {
    public static void handleException(WSRPException e) throws RemoteException {
        AxisFault fault = new AxisFault();
        QName qname = new QName(Fault.getTypeDesc().getXmlType().getNamespaceURI(), e.getFault());
        fault.setFaultCode(qname);
        fault.setFaultString(e.getMessage());
        try {
            Document doc = XMLUtils.newDocument();
            Element element = doc.createElementNS(Exception2Fault.getNameSpace(e.getFault()), e.getFault());
            fault.clearFaultDetails();
            fault.setFaultDetail(new Element[]{element});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        throw fault;
    }

    public static String getNameSpace(String fault) {
        if ("AccessDenied".equals(fault)) {
            return AccessDeniedFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InconsistenParameters".equals(fault)) {
            return InconsistentParametersFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InvalidCookie".equals(fault)) {
            return InvalidCookieFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InvalidHandle".equals(fault)) {
            return InvalidHandleFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InvalidRegistration".equals(fault)) {
            return InvalidRegistrationFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InvalidSession".equals(fault)) {
            return InvalidSessionFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("InvalidUserCategory".equals(fault)) {
            return InvalidUserCategoryFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("MissingParameters".equals(fault)) {
            return MissingParametersFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("OperationFailed".equals(fault)) {
            return OperationFailedFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("PortletStateChangeRequired".equals(fault)) {
            return PortletStateChangeRequiredFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("UnsupportedLocale".equals(fault)) {
            return UnsupportedLocaleFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("UnsupportedMimeType".equals(fault)) {
            return UnsupportedMimeTypeFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("UnsupportedMode".equals(fault)) {
            return UnsupportedModeFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        if ("UnsupportedWindowState".equals(fault)) {
            return UnsupportedWindowStateFault.getTypeDesc().getXmlType().getNamespaceURI();
        }
        return null;
    }
}

