/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.EventInput;
import org.exoplatform.services.portletcontainer.pci.EventOutput;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.PortletURLFactory;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceInput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletDataImp;
import org.exoplatform.services.wsrp2.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.MarkupOperationsInterface;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;
import org.exoplatform.services.wsrp2.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp2.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp2.producer.TransientStateManager;
import org.exoplatform.services.wsrp2.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp2.producer.impl.WSRPPortletPreferencesPersister;
import org.exoplatform.services.wsrp2.producer.impl.helpers.Helper;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPConsumerRewriterPortletURLFactory;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHTTPContainer;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHttpServletRequest;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHttpServletResponse;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPHttpSession;
import org.exoplatform.services.wsrp2.producer.impl.helpers.WSRPProducerRewriterPortletURLFactory;
import org.exoplatform.services.wsrp2.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp2.type.CacheControl;
import org.exoplatform.services.wsrp2.type.EventParams;
import org.exoplatform.services.wsrp2.type.HandleEventsFailed;
import org.exoplatform.services.wsrp2.type.HandleEventsResponse;
import org.exoplatform.services.wsrp2.type.InteractionParams;
import org.exoplatform.services.wsrp2.type.LocalizedString;
import org.exoplatform.services.wsrp2.type.MarkupContext;
import org.exoplatform.services.wsrp2.type.MarkupParams;
import org.exoplatform.services.wsrp2.type.MarkupResponse;
import org.exoplatform.services.wsrp2.type.NavigationalContext;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.ResourceContext;
import org.exoplatform.services.wsrp2.type.ResourceParams;
import org.exoplatform.services.wsrp2.type.ResourceResponse;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.RuntimeContext;
import org.exoplatform.services.wsrp2.type.SessionContext;
import org.exoplatform.services.wsrp2.type.StateChange;
import org.exoplatform.services.wsrp2.type.Templates;
import org.exoplatform.services.wsrp2.type.UpdateResponse;
import org.exoplatform.services.wsrp2.type.UserContext;
import org.exoplatform.services.wsrp2.utils.JAXBEventTransformer;
import org.exoplatform.services.wsrp2.utils.Modes;
import org.exoplatform.services.wsrp2.utils.Utils;
import org.exoplatform.services.wsrp2.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupOperationsInterfaceImpl
implements MarkupOperationsInterface {
    private Log log;
    private WSRPConfiguration conf;
    private PersistentStateManager persistentStateManager;
    private PortletContainerProxy proxy;
    private TransientStateManager transientStateManager;
    private PortletManagementOperationsInterface portletManagementOperationsInterface;
    private WSRPPortletPreferencesPersister persister;

    public MarkupOperationsInterfaceImpl(PortletManagementOperationsInterface portletManagementOperationsInterface, PersistentStateManager persitentStateManager, TransientStateManager transientStateManager, PortletContainerProxy proxy, WSRPConfiguration conf, OrganizationService orgService) {
        this.portletManagementOperationsInterface = portletManagementOperationsInterface;
        this.proxy = proxy;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
        this.conf = conf;
        this.persistentStateManager = persitentStateManager;
        this.transientStateManager = transientStateManager;
        this.persister = WSRPPortletPreferencesPersister.getInstance();
    }

    @Override
    public MarkupResponse getMarkup(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams) throws RemoteException {
        if (!Helper.checkLifetime(registrationContext, userContext) || !Helper.checkPortletLifetime(registrationContext, new PortletContext[]{portletContext}, userContext, this.portletManagementOperationsInterface)) {
            return null;
        }
        String portletHandle = portletContext.getPortletHandle();
        portletHandle = this.manageRegistration(portletHandle, registrationContext);
        this.log.debug((Object)("Portlet handle : " + portletHandle));
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        String uniqueID = k[2];
        Integer sessiontimeperiod = this.getSessionTimePeriod();
        String sessionID = runtimeContext.getSessionParams().getSessionID();
        WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getId());
        sessionContext.setExpires(sessiontimeperiod);
        userContext = this.transientStateManager.resolveUserContext(userContext, session);
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        if (markupParams.getValidateTag() != null) {
            try {
                if (this.transientStateManager.validateCache(markupParams.getValidateTag())) {
                    MarkupContext markupContext = new MarkupContext();
                    markupContext.setUseCachedItem(new Boolean(true));
                    MarkupResponse markup = new MarkupResponse();
                    markup.setMarkupContext(markupContext);
                    markup.setSessionContext(sessionContext);
                    return markup;
                }
            }
            catch (WSRPException e) {
                this.log.debug((Object)("Can not validate Cache for validateTag : " + markupParams.getValidateTag()));
                Exception2Fault.handleException(e);
            }
        }
        PortletData portletData = this.getPortletMetaData(portletApplicationName + "/" + portletName);
        List publicParamNames = portletData.getSupportedPublicRenderParameter();
        NavigationalContext navigationalContext = markupParams.getNavigationalContext();
        Map<String, String[]> persistentNavigationalParameters = this.processNavigationalState(navigationalContext);
        Map<String, String[]> navigationalParameters = Utils.getMapParametersFromNamedStringArray(navigationalContext.getPublicValues());
        Map<String, String[]> renderParameters = new HashMap<String, String[]>();
        if (persistentNavigationalParameters != null && !persistentNavigationalParameters.isEmpty()) {
            renderParameters = persistentNavigationalParameters;
        }
        this.replacePublicParams(renderParameters, publicParamNames, navigationalParameters);
        byte[] portletState = this.managePortletState(portletContext);
        String mimeType = null;
        try {
            mimeType = this.getMimeType(markupParams.getMimeTypes(), portletData);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String baseURL = null;
        Object portletURLFactory = null;
        if (this.conf.isDoesUrlTemplateProcessing()) {
            this.log.debug((Object)"Producer URL rewriting");
            Templates templates = this.manageTemplates(runtimeContext, session);
            baseURL = templates.getRenderTemplate();
            portletURLFactory = new WSRPProducerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        } else {
            this.log.debug((Object)"Consumer URL rewriting");
            portletURLFactory = new WSRPConsumerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        }
        PortletMode portletMode = Modes.getJsrPortletMode(markupParams.getMode());
        WindowState windowState = WindowStates.getJsrWindowState(markupParams.getWindowState());
        WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
        WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
        WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
        request.setParameters(renderParameters);
        RenderInput input = new RenderInput();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(portletApplicationName);
        windowID.setPortletName(portletName);
        windowID.setUniqueID(uniqueID);
        input.setInternalWindowID((WindowID)windowID);
        input.setBaseURL(baseURL);
        input.setPortletURLFactory((PortletURLFactory)portletURLFactory);
        input.setEscapeXml(true);
        input.setUserAttributes(new HashMap());
        input.setPortletMode(portletMode);
        input.setWindowState(windowState);
        input.setMarkup(mimeType);
        input.setRenderParameters(renderParameters);
        input.setPublicParamNames(publicParamNames);
        input.setPortletState(portletState);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        RenderOutput output = null;
        try {
            output = this.proxy.render(request, response, input);
            if (output.hasError()) {
                throw new WSRPException("render output hasError");
            }
        }
        catch (WSRPException e) {
            this.log.debug((Object)"The call to render method was a failure ", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        CacheControl cacheControl = null;
        try {
            cacheControl = this.transientStateManager.getCacheControl(portletData);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setCacheControl(cacheControl);
        markupContext.setItemBinary(output.getBinContent());
        markupContext.setItemString(this.removeNonValidXMLCharacters(new String(output.getContent())));
        markupContext.setLocale("en");
        markupContext.setMimeType(mimeType);
        markupContext.setPreferredTitle(output.getTitle());
        markupContext.setRequiresRewriting(!this.conf.isDoesUrlTemplateProcessing());
        markupContext.setUseCachedItem(false);
        markupContext.setValidNewModes(null);
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext(markupContext);
        markupResponse.setSessionContext(sessionContext);
        return markupResponse;
    }

    private PortletData getPortletMetaData(String portletHandle) {
        if (this.proxy != null) {
            return this.proxy.getAllPortletMetaData().get(portletHandle);
        }
        return null;
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, InteractionParams interactionParams) throws RemoteException {
        if (!Helper.checkLifetime(registrationContext, userContext) || !Helper.checkPortletLifetime(registrationContext, new PortletContext[]{portletContext}, userContext, this.portletManagementOperationsInterface)) {
            return null;
        }
        String portletHandle = portletContext.getPortletHandle();
        portletHandle = this.manageRegistration(portletHandle, registrationContext);
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        String uniqueID = k[2];
        Integer sessiontimeperiod = this.getSessionTimePeriod();
        String sessionID = runtimeContext.getSessionParams().getSessionID();
        WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getId());
        sessionContext.setExpires(sessiontimeperiod);
        userContext = this.transientStateManager.resolveUserContext(userContext, session);
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        PortletData portletData = this.getPortletMetaData(portletApplicationName + "/" + portletName);
        String mimeType = null;
        try {
            mimeType = this.getMimeType(markupParams.getMimeTypes(), portletData);
        }
        catch (WSRPException e) {
            e.printStackTrace();
            Exception2Fault.handleException(e);
        }
        String baseURL = null;
        Object portletURLFactory = null;
        if (this.conf.isDoesUrlTemplateProcessing()) {
            this.log.debug((Object)"Producer URL rewriting");
            Templates templates = this.manageTemplates(runtimeContext, session);
            baseURL = templates.getBlockingActionTemplate();
            portletURLFactory = new WSRPProducerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        } else {
            this.log.debug((Object)"Consumer URL rewriting");
            portletURLFactory = new WSRPConsumerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        }
        byte[] portletState = this.managePortletState(portletContext);
        PortletMode portletMode = Modes.getJsrPortletMode(markupParams.getMode());
        WindowState windowState = WindowStates.getJsrWindowState(markupParams.getWindowState());
        boolean isStateChangeAuthorized = false;
        String stateChange = interactionParams.getPortletStateChange().getValue();
        if (StateChange.readWrite.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"readWrite state change");
            isStateChangeAuthorized = true;
        } else if (StateChange.cloneBeforeWrite.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"cloneBeforWrite state change");
            portletContext = this.portletManagementOperationsInterface.clonePortlet(registrationContext, portletContext, userContext);
            isStateChangeAuthorized = true;
        } else if (StateChange.readOnly.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"readOnly state change");
        } else {
            this.log.debug((Object)("The submited portlet state change value : " + stateChange + " is not supported"));
            Exception2Fault.handleException(new WSRPException("PortletStateChangeRequired"));
        }
        List publicParamNames = portletData.getSupportedPublicRenderParameter();
        NavigationalContext navigationalContext = markupParams.getNavigationalContext();
        Map<String, String[]> persistentNavigationalParameters = this.processNavigationalState(navigationalContext);
        Map<String, String[]> navigationalParameters = Utils.getMapParametersFromNamedStringArray(navigationalContext.getPublicValues());
        Map<String, String[]> formParameters = Utils.getMapParametersFromNamedStringArray(interactionParams.getFormParameters());
        Map<String, String[]> persistentInteractionParameters = this.processInteractionState(interactionParams.getInteractionState());
        HashMap<String, String[]> renderParameters = new HashMap();
        if (formParameters != null && !formParameters.isEmpty()) {
            renderParameters = formParameters;
        } else if (persistentInteractionParameters != null && !persistentInteractionParameters.isEmpty()) {
            renderParameters = persistentInteractionParameters;
        } else if (persistentNavigationalParameters != null && !persistentNavigationalParameters.isEmpty()) {
            renderParameters = persistentNavigationalParameters;
        }
        this.replacePublicParams(renderParameters, publicParamNames, navigationalParameters);
        WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
        WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
        WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
        request.setParameters(renderParameters);
        ActionInput input = new ActionInput();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(portletApplicationName);
        windowID.setPortletName(portletName);
        windowID.setUniqueID(uniqueID);
        input.setInternalWindowID((WindowID)windowID);
        input.setBaseURL(baseURL);
        input.setPortletURLFactory((PortletURLFactory)portletURLFactory);
        input.setEscapeXml(true);
        input.setUserAttributes(new HashMap());
        input.setPortletMode(portletMode);
        input.setWindowState(windowState);
        input.setMarkup(mimeType);
        input.setStateChangeAuthorized(isStateChangeAuthorized);
        input.setStateSaveOnClient(this.conf.isSavePortletStateOnConsumer());
        input.setPortletState(portletState);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        input.setRenderParameters(renderParameters);
        input.setPublicParamNames(publicParamNames);
        ActionOutput output = null;
        try {
            output = this.proxy.processAction(request, response, input);
            if (output.hasError()) {
                throw new WSRPException("processAction output hasError()");
            }
        }
        catch (WSRPException e) {
            e.printStackTrace();
            this.log.debug((Object)"The call to processAction method was a failure ", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        BlockingInteractionResponse blockingInteractionResponse = new BlockingInteractionResponse();
        if (output.getProperties().get("_send_redirect_") != null) {
            this.log.debug((Object)("Redirect the response to : " + (String)output.getProperties().get("_send_redirect_")));
            blockingInteractionResponse.setRedirectURL((String)output.getProperties().get("_send_redirect_"));
            blockingInteractionResponse.setUpdateResponse(null);
        } else {
            MarkupContext markupContext = null;
            if (this.conf.isBlockingInteractionOptimized()) {
                MarkupResponse markupResponse = this.getMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams);
                markupContext = markupResponse.getMarkupContext();
            }
            UpdateResponse updateResponse = new UpdateResponse();
            if (output.getNextMode() != null) {
                updateResponse.setNewMode(Modes.getWSRPModeString(output.getNextMode()));
            }
            if (output.getNextState() != null) {
                updateResponse.setNewWindowState(WindowStates.getWSRPStateString(output.getNextState()));
            }
            updateResponse.setSessionContext(sessionContext);
            updateResponse.setMarkupContext(markupContext);
            if (this.conf.isSavePortletStateOnConsumer()) {
                portletContext.setPortletState(output.getPortletState());
            }
            updateResponse.setPortletContext(portletContext);
            updateResponse.setExtensions(null);
            renderParameters = output.getRenderParameters();
            String navigationalState = IdentifierUtil.generateUUID((Object)output);
            try {
                this.log.debug((Object)("set new navigational state : " + navigationalState));
                this.persistentStateManager.putNavigationalState(navigationalState, renderParameters);
            }
            catch (WSRPException e) {
                e.printStackTrace();
                Exception2Fault.handleException(e);
            }
            HashMap<String, String[]> publicParameters = null;
            if (publicParamNames != null) {
                publicParameters = new HashMap<String, String[]>();
                for (String name : publicParamNames) {
                    if (!renderParameters.containsKey(name)) continue;
                    publicParameters.put(name, (String[])renderParameters.get(name));
                }
            }
            NavigationalContext newNavigationalContext = new NavigationalContext();
            newNavigationalContext.setOpaqueValue(navigationalState);
            newNavigationalContext.setPublicValues(Utils.getNamedStringArrayParametersFromMap(publicParameters));
            newNavigationalContext.setExtensions(null);
            updateResponse.setNavigationalContext(newNavigationalContext);
            updateResponse.setEvents(JAXBEventTransformer.getEventsMarshal(output.getEvents()));
            blockingInteractionResponse.setUpdateResponse(updateResponse);
        }
        return blockingInteractionResponse;
    }

    private void replacePublicParams(Map<String, String[]> renderParameters, List<String> publicParamNames, Map<String, String[]> navigationalParameters) {
        if (publicParamNames != null) {
            for (String param : publicParamNames) {
                if (!renderParameters.containsKey(param)) continue;
                renderParameters.remove(param);
            }
        }
        if (navigationalParameters != null) {
            renderParameters.putAll(navigationalParameters);
        }
    }

    @Override
    public ResourceResponse getResource(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, ResourceParams resourceParams) throws RemoteException {
        if (!Helper.checkLifetime(registrationContext, userContext) || !Helper.checkPortletLifetime(registrationContext, new PortletContext[]{portletContext}, userContext, this.portletManagementOperationsInterface)) {
            return null;
        }
        String portletHandle = portletContext.getPortletHandle();
        portletHandle = this.manageRegistration(portletHandle, registrationContext);
        this.log.debug((Object)("Portlet handle : " + portletHandle));
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        String uniqueID = k[2];
        Integer sessiontimeperiod = this.getSessionTimePeriod();
        String sessionID = runtimeContext.getSessionParams().getSessionID();
        WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getId());
        sessionContext.setExpires(sessiontimeperiod);
        userContext = this.transientStateManager.resolveUserContext(userContext, session);
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        PortletData portletData = this.getPortletMetaData(portletApplicationName + "/" + portletName);
        List publicParamNames = portletData.getSupportedPublicRenderParameter();
        NavigationalContext navigationalContext = resourceParams.getNavigationalContext();
        Map<String, String[]> persistentNavigationalParameters = this.processNavigationalState(navigationalContext);
        Map<String, String[]> navigationalParameters = Utils.getMapParametersFromNamedStringArray(navigationalContext.getPublicValues());
        Map<String, String[]> formParameters = Utils.getMapParametersFromNamedStringArray(resourceParams.getFormParameters());
        Map<String, String[]> persistentResourceParameters = this.processResourceState(resourceParams.getResourceState());
        HashMap<String, String[]> renderParameters = new HashMap();
        if (formParameters != null && !formParameters.isEmpty()) {
            renderParameters = formParameters;
        } else if (persistentResourceParameters != null && !persistentResourceParameters.isEmpty()) {
            renderParameters = persistentResourceParameters;
        } else if (persistentNavigationalParameters != null && !persistentNavigationalParameters.isEmpty()) {
            renderParameters = persistentNavigationalParameters;
        }
        this.replacePublicParams(renderParameters, publicParamNames, navigationalParameters);
        byte[] portletState = this.managePortletState(portletContext);
        String mimeType = null;
        try {
            mimeType = this.getMimeType(resourceParams.getMimeTypes(), portletData);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String baseURL = null;
        Object portletURLFactory = null;
        if (this.conf.isDoesUrlTemplateProcessing()) {
            this.log.debug((Object)"Producer URL rewriting");
            Templates templates = this.manageTemplates(runtimeContext, session);
            baseURL = templates.getResourceTemplate();
            portletURLFactory = new WSRPProducerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), resourceParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), resourceParams.getResourceCacheability(), portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        } else {
            this.log.debug((Object)"Consumer URL rewriting");
            portletURLFactory = new WSRPConsumerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), resourceParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), resourceParams.getResourceCacheability(), portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
        }
        PortletMode portletMode = Modes.getJsrPortletMode(resourceParams.getMode());
        WindowState windowState = WindowStates.getJsrWindowState(resourceParams.getWindowState());
        WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
        WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
        WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
        request.setParameters(renderParameters);
        ResourceInput input = new ResourceInput();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(portletApplicationName);
        windowID.setPortletName(portletName);
        windowID.setUniqueID(uniqueID);
        input.setInternalWindowID((WindowID)windowID);
        input.setBaseURL(baseURL);
        input.setPortletURLFactory((PortletURLFactory)portletURLFactory);
        input.setEscapeXml(true);
        input.setUserAttributes(new HashMap());
        input.setPortletMode(portletMode);
        input.setWindowState(windowState);
        input.setMarkup(mimeType);
        input.setRenderParameters(renderParameters);
        input.setPublicParamNames(publicParamNames);
        input.setPortletState(portletState);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        input.setResourceID(resourceParams.getResourceID());
        input.setCacheability(resourceParams.getResourceCacheability());
        ResourceOutput output = null;
        try {
            output = this.proxy.serveResource(request, response, input);
            if (output.hasError()) {
                throw new WSRPException("serveResource output hasError");
            }
        }
        catch (WSRPException e) {
            this.log.debug((Object)"The call to render method was a failure ", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        CacheControl cacheControl = null;
        try {
            cacheControl = this.transientStateManager.getCacheControl(portletData);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        ResourceContext resourceContext = new ResourceContext();
        resourceContext.setCacheControl(cacheControl);
        resourceContext.setItemBinary(output.getBinContent());
        resourceContext.setItemString(this.removeNonValidXMLCharacters(new String(output.getContent())));
        resourceContext.setLocale("en");
        resourceContext.setMimeType(output.getContentType());
        resourceContext.setRequiresRewriting(!this.conf.isDoesUrlTemplateProcessing());
        resourceContext.setUseCachedItem(Boolean.FALSE);
        ResourceResponse resourceResponse = new ResourceResponse();
        resourceResponse.setPortletContext(portletContext);
        resourceResponse.setResourceContext(resourceContext);
        resourceResponse.setSessionContext(sessionContext);
        return resourceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleEventsResponse handleEvents(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, EventParams eventParams) throws RemoteException {
        try {
            if (!Helper.checkLifetime(registrationContext, userContext) || !Helper.checkPortletLifetime(registrationContext, new PortletContext[]{portletContext}, userContext, this.portletManagementOperationsInterface)) {
                return null;
            }
            System.out.println(">>> EXOMAN MarkupOperationsInterfaceImpl.handleEvents() eventParams.getEvents()[0].getName() = " + eventParams.getEvents()[0].getName());
            String portletHandle = portletContext.getPortletHandle();
            portletHandle = this.manageRegistration(portletHandle, registrationContext);
            String[] k = StringUtils.split((String)portletHandle, (String)"/");
            String portletApplicationName = k[0];
            String portletName = k[1];
            String uniqueID = k[2];
            Integer sessiontimeperiod = this.getSessionTimePeriod();
            String sessionID = runtimeContext.getSessionParams().getSessionID();
            WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
            SessionContext sessionContext = new SessionContext();
            sessionContext.setSessionID(session.getId());
            sessionContext.setExpires(sessiontimeperiod);
            userContext = this.transientStateManager.resolveUserContext(userContext, session);
            String owner = userContext.getUserContextKey();
            this.log.debug((Object)("Owner Context : " + owner));
            PortletData portletData = this.getPortletMetaData(portletApplicationName + "/" + portletName);
            String mimeType = null;
            try {
                mimeType = this.getMimeType(markupParams.getMimeTypes(), portletData);
            }
            catch (WSRPException e) {
                Exception2Fault.handleException(e);
            }
            String baseURL = null;
            Object portletURLFactory = null;
            if (this.conf.isDoesUrlTemplateProcessing()) {
                this.log.debug((Object)"Producer URL rewriting");
                Templates templates = this.manageTemplates(runtimeContext, session);
                baseURL = templates.getRenderTemplate();
                portletURLFactory = new WSRPProducerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
            } else {
                this.log.debug((Object)"Consumer URL rewriting");
                portletURLFactory = new WSRPConsumerRewriterPortletURLFactory(mimeType, baseURL, portletData.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID, portletData.getEscapeXml(), "cacheLevelPage", portletData.getSupportedPublicRenderParameter(), ((PortletDataImp)portletData).getWrappedPortletTyped());
            }
            byte[] portletState = this.managePortletState(portletContext);
            PortletMode portletMode = Modes.getJsrPortletMode(markupParams.getMode());
            WindowState windowState = WindowStates.getJsrWindowState(markupParams.getWindowState());
            boolean isStateChangeAuthorized = false;
            String stateChange = eventParams.getPortletStateChange().getValue();
            if (StateChange.readWrite.getValue().equalsIgnoreCase(stateChange)) {
                this.log.debug((Object)"readWrite state change");
                isStateChangeAuthorized = true;
            } else if (StateChange.cloneBeforeWrite.getValue().equalsIgnoreCase(stateChange)) {
                this.log.debug((Object)"cloneBeforWrite state change");
                portletContext = this.portletManagementOperationsInterface.clonePortlet(registrationContext, portletContext, userContext);
                isStateChangeAuthorized = true;
            } else if (StateChange.readOnly.getValue().equalsIgnoreCase(stateChange)) {
                this.log.debug((Object)"readOnly state change");
            } else {
                this.log.debug((Object)("The submited portlet state change value : " + stateChange + " is not supported"));
                Exception2Fault.handleException(new WSRPException("PortletStateChangeRequired"));
            }
            HandleEventsResponse handleEventsResponse = new HandleEventsResponse();
            ArrayList<HandleEventsFailed> failedEventsList = new ArrayList<HandleEventsFailed>();
            org.exoplatform.services.wsrp2.type.Event[] events = eventParams.getEvents();
            List<Event> nativeEventsList = JAXBEventTransformer.getEventsUnmarshal(events);
            ArrayList<Event> resultNativeEventsList = new ArrayList<Event>();
            List publicParamNames = portletData.getSupportedPublicRenderParameter();
            NavigationalContext navigationalContext = markupParams.getNavigationalContext();
            Map<String, String[]> persistentNavigationalParameters = this.processNavigationalState(navigationalContext);
            Map<String, String[]> navigationalParameters = Utils.getMapParametersFromNamedStringArray(navigationalContext.getPublicValues());
            Map<String, String[]> renderParameters = new HashMap<String, String[]>();
            if (persistentNavigationalParameters != null && !persistentNavigationalParameters.isEmpty()) {
                renderParameters = persistentNavigationalParameters;
            }
            this.replacePublicParams(renderParameters, publicParamNames, navigationalParameters);
            WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
            WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
            WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
            request.setParameters(renderParameters);
            String navigationalState = null;
            Integer index = 0;
            int eventsLength = events.length;
            Iterator<Event> nativeEventsListIterator = nativeEventsList.iterator();
            EventOutput output = null;
            if (nativeEventsListIterator.hasNext()) {
                Serializable handleEventsFailed;
                Event event = nativeEventsListIterator.next();
                EventInput input = new EventInput();
                ExoWindowID windowID = new ExoWindowID();
                windowID.setOwner(owner);
                windowID.setPortletApplicationName(portletApplicationName);
                windowID.setPortletName(portletName);
                windowID.setUniqueID(uniqueID);
                input.setInternalWindowID((WindowID)windowID);
                input.setBaseURL(baseURL);
                input.setPortletURLFactory((PortletURLFactory)portletURLFactory);
                input.setEscapeXml(true);
                input.setUserAttributes(new HashMap());
                input.setPortletMode(portletMode);
                input.setWindowState(windowState);
                input.setMarkup(mimeType);
                input.setEvent(event);
                input.setRenderParameters(renderParameters);
                input.setPublicParamNames(publicParamNames);
                input.setStateSaveOnClient(this.conf.isSavePortletStateOnConsumer());
                input.setPortletState(portletState);
                input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
                try {
                    output = this.proxy.processEvent(request, response, input);
                    if (output.hasError()) {
                        throw new WSRPException("processEvent output hasError");
                    }
                }
                catch (WSRPException e) {
                    this.log.debug((Object)("The call to processEvent with event: '" + event.getName() + "' method was a failure "), (Throwable)e);
                    handleEventsFailed = new HandleEventsFailed();
                    handleEventsFailed.setReason(new LocalizedString(e.getLocalizedMessage(), ""));
                    BigInteger indexBigInteger = new BigInteger(index.toString());
                    handleEventsFailed.setIndex(new BigInteger[]{indexBigInteger});
                    failedEventsList.add((HandleEventsFailed)handleEventsFailed);
                    Exception2Fault.handleException(e);
                }
                finally {
                    Integer e = index;
                    index = index + 1;
                    handleEventsFailed = index;
                }
                resultNativeEventsList.addAll(output.getEvents());
                renderParameters = output.getRenderParameters();
                navigationalState = IdentifierUtil.generateUUID((Object)output);
                try {
                    this.log.debug((Object)("set new navigational state : " + navigationalState));
                    this.persistentStateManager.putNavigationalState(navigationalState, renderParameters);
                }
                catch (WSRPException e) {
                    Exception2Fault.handleException(e);
                }
            }
            UpdateResponse updateResponse = new UpdateResponse();
            updateResponse.setEvents(JAXBEventTransformer.getEventsMarshal(resultNativeEventsList));
            if (output.getNextMode() != null) {
                updateResponse.setNewMode(Modes.getWSRPModeString(output.getNextMode()));
            }
            if (output.getNextState() != null) {
                updateResponse.setNewWindowState(WindowStates.getWSRPStateString(output.getNextState()));
            }
            updateResponse.setSessionContext(sessionContext);
            MarkupContext markupContext = null;
            updateResponse.setMarkupContext(markupContext);
            updateResponse.setPortletContext(portletContext);
            updateResponse.setExtensions(null);
            HashMap<String, String[]> publicParameters = new HashMap<String, String[]>();
            if (publicParamNames != null) {
                for (String name : publicParamNames) {
                    if (!renderParameters.containsKey(name)) continue;
                    publicParameters.put(name, renderParameters.get(name));
                }
            }
            NavigationalContext newNavigationalContext = new NavigationalContext();
            newNavigationalContext.setOpaqueValue(navigationalState);
            newNavigationalContext.setPublicValues(Utils.getNamedStringArrayParametersFromMap(publicParameters));
            updateResponse.setNavigationalContext(navigationalContext);
            handleEventsResponse.setUpdateResponse(updateResponse);
            handleEventsResponse.setFailedEvents(failedEventsList.toArray(new HandleEventsFailed[failedEventsList.size()]));
            return handleEventsResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ReturnAny initCookie(RegistrationContext registrationContext) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        return new ReturnAny();
    }

    @Override
    public ReturnAny initCookie(RegistrationContext registrationContext, UserContext userContext) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            } else {
                String owner = userContext.getUserContextKey();
                this.log.debug((Object)("Logged Owner Context : " + owner));
            }
        }
        return new ReturnAny();
    }

    @Override
    public ReturnAny releaseSessions(RegistrationContext registrationContext, String[] sessionIDs) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        for (int i = 0; i < sessionIDs.length; ++i) {
            this.transientStateManager.releaseSession(sessionIDs[i]);
        }
        return new ReturnAny();
    }

    @Override
    public ReturnAny releaseSessions(RegistrationContext registrationContext, String[] sessionIDs, UserContext userContext) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Released Owner Context : " + owner));
        for (int i = 0; i < sessionIDs.length; ++i) {
            this.transientStateManager.releaseSession(sessionIDs[i]);
        }
        return new ReturnAny();
    }

    private WSRPHttpSession resolveSession(String sessionID, String user, Integer sessiontimeperiod) throws RemoteException {
        WSRPHttpSession session = null;
        try {
            session = this.transientStateManager.resolveSession(sessionID, user, sessiontimeperiod);
        }
        catch (WSRPException e) {
            this.log.debug((Object)("Can not lookup or create new session, sessionID parameter : " + sessionID));
            Exception2Fault.handleException(e);
        }
        this.log.debug((Object)("Use session with ID : " + session.getId()));
        return session;
    }

    private String manageRegistration(String portletHandle, RegistrationContext registrationContext) throws RemoteException {
        this.log.debug((Object)("manageRegistration called for portlet handle : " + portletHandle));
        if (!this.proxy.isPortletOffered(portletHandle)) {
            this.log.debug((Object)"The latter handle is not offered by the Producer");
            Exception2Fault.handleException(new WSRPException("InvalidHandle"));
        } else {
            String[] keys = StringUtils.split((String)portletHandle, (String)"/");
            if (keys.length == 2) {
                portletHandle = portletHandle + "/" + String.valueOf(portletHandle.hashCode());
            }
        }
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        } else {
            this.log.debug((Object)"Registration non required");
        }
        return portletHandle;
    }

    private Map<String, String[]> processNavigationalState(NavigationalContext navigationalContext) throws RemoteException {
        Map<String, String[]> map = null;
        try {
            String navigationalState = navigationalContext.getOpaqueValue();
            this.log.debug((Object)("Lookup navigational state : " + navigationalState));
            map = this.persistentStateManager.getNavigationalState(navigationalState);
            if (this.log.isDebugEnabled() && map != null) {
                for (String key : map.keySet()) {
                    this.log.debug((Object)("attribute name in map referenced by navigationalState : " + key));
                }
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        return map;
    }

    private Map<String, String[]> processInteractionState(String interactionState) throws RemoteException {
        Map<Object, Object> map = null;
        try {
            this.log.debug((Object)("Lookup interaction state : " + interactionState));
            map = this.persistentStateManager.getInteractionSate(interactionState);
            if (this.log.isDebugEnabled() && map != null) {
                for (String string : map.keySet()) {
                    this.log.debug((Object)("attribute name in map referenced by interactionState : " + string));
                }
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private Map<String, String[]> processResourceState(String resourceState) throws RemoteException {
        Map<Object, Object> map = null;
        try {
            this.log.debug((Object)("Lookup resource state : " + resourceState));
            map = this.persistentStateManager.getResourceState(resourceState);
            if (this.log.isDebugEnabled() && map != null) {
                for (String string : map.keySet()) {
                    this.log.debug((Object)("attribute name in map referenced by resourceState : " + string));
                }
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private String getMimeType(String[] mimeTypes, PortletData portletData) throws WSRPException {
        if (mimeTypes == null || mimeTypes.length == 0) {
            this.log.debug((Object)"the given array of MimeTypes is empty or null");
            throw new WSRPException("MissingParameters");
        }
        List l = portletData.getSupports();
        for (int i = 0; i < mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i];
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                String supports = ((Supports)iterator.next()).getMimeType();
                if (!supports.equalsIgnoreCase(mimeType)) continue;
                return mimeType;
            }
        }
        this.log.debug((Object)"No mime type is supported");
        throw new WSRPException("UnsupportedMimeType");
    }

    private byte[] managePortletState(PortletContext portletContext) {
        if (this.conf.isSavePortletStateOnConsumer()) {
            this.log.debug((Object)"Save state on consumer");
            return portletContext.getPortletState();
        }
        this.log.debug((Object)"Save state on producer");
        return null;
    }

    private Templates manageTemplates(RuntimeContext runtimeContext, WSRPHttpSession session) {
        Templates templates = runtimeContext.getTemplates();
        if (this.conf.isTemplatesStoredInSession()) {
            this.log.debug((Object)"Optimized mode : templates store in session");
            if (templates == null) {
                this.log.debug((Object)"Optimized mode : retrieves the template from session");
                templates = this.transientStateManager.getTemplates(session);
            } else {
                this.log.debug((Object)"Optimized mode : store the templates in session");
                this.transientStateManager.storeTemplates(templates, session);
            }
        }
        return templates;
    }

    private Integer getSessionTimePeriod() {
        try {
            WSRPHttpSession wsrpHttpSession = (WSRPHttpSession)WSRPHTTPContainer.getInstance().getRequest().getSession();
            return wsrpHttpSession.getMaxInactiveInterval();
        }
        catch (Exception e) {
            System.out.println("MarkupOperationsInterfaceImpl.getSessionTimePeriod: = " + e.getCause());
            e.printStackTrace();
            return 900;
        }
    }

    private String removeNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

