/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl.helpers;

import java.rmi.RemoteException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.wsrp2.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp2.producer.RegistrationOperationsInterface;
import org.exoplatform.services.wsrp2.type.GetPortletsLifetimeResponse;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.PortletContext;
import org.exoplatform.services.wsrp2.type.PortletLifetime;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.UserContext;

public class Helper {
    public static boolean checkLifetime(RegistrationContext registrationContext, UserContext userContext) {
        ExoContainer cont = ExoContainerContext.getCurrentContainer();
        RegistrationOperationsInterface roi = (RegistrationOperationsInterface)cont.getComponentInstanceOfType(RegistrationOperationsInterface.class);
        try {
            Lifetime lf = roi.getRegistrationLifetime(registrationContext, userContext);
            if (lf != null && lf.getTerminationTime().getTimeInMillis() > lf.getCurrentTime().getTimeInMillis()) {
                roi.deregister(registrationContext, userContext);
                return false;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkPortletLifetime(RegistrationContext registrationContext, PortletContext[] portletContexts, UserContext userContext, PortletManagementOperationsInterface poi) {
        try {
            PortletLifetime plf;
            Lifetime lf;
            GetPortletsLifetimeResponse resp = poi.getPortletsLifetime(registrationContext, portletContexts, userContext);
            if (resp != null && resp.getPortletLifetime() != null && resp.getPortletLifetime().length != 0 && (lf = (plf = resp.getPortletLifetime(0)).getScheduledDestruction()) != null && lf.getTerminationTime().getTimeInMillis() > lf.getCurrentTime().getTimeInMillis()) {
                String portletHandle = portletContexts[0].getPortletHandle();
                poi.destroyPortlets(registrationContext, new String[]{portletHandle});
                return false;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return true;
    }
}

