/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.utils;

import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.message.MessageElement;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.EventImpl;
import org.exoplatform.services.wsrp2.type.EventPayload;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBEventTransformer {
    private static final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2.utils.JAXBEventTransformer");

    public static org.exoplatform.services.wsrp2.type.Event[] getEventsMarshal(Event event) {
        return new org.exoplatform.services.wsrp2.type.Event[]{JAXBEventTransformer.getEventMarshal(event)};
    }

    public static org.exoplatform.services.wsrp2.type.Event[] getEventsMarshal(List<Event> eventsList) {
        org.exoplatform.services.wsrp2.type.Event[] events = new org.exoplatform.services.wsrp2.type.Event[eventsList.size()];
        int i = 0;
        for (Event event : eventsList) {
            events[i++] = JAXBEventTransformer.getEventMarshal(event);
        }
        return events;
    }

    public static org.exoplatform.services.wsrp2.type.Event getEventMarshal(Event event) {
        if (event == null) {
            return null;
        }
        QName eventName = event.getQName();
        Serializable eventValue = event.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getEventMarshal() eventName = " + eventName));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getEventMarshal() eventValue = " + eventValue));
        }
        org.exoplatform.services.wsrp2.type.Event newEvent = new org.exoplatform.services.wsrp2.type.Event();
        newEvent.setName(eventName);
        if (eventValue != null) {
            String eventType = eventValue.getClass().getName();
            newEvent.setType(new QName(eventType));
            Document doc = JAXBEventTransformer.getMarshalledDocument(eventValue, eventName);
            if (doc == null) {
                try {
                    doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{eventValue.getClass()});
                    Marshaller marshaller = jaxb.createMarshaller();
                    marshaller.marshal((Object)eventValue, (Node)doc);
                }
                catch (JAXBException je) {
                    je.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            MessageElement messageElement = new MessageElement(doc.getDocumentElement());
            MessageElement[] anyArray = new MessageElement[]{messageElement};
            EventPayload eventPayload = new EventPayload();
            eventPayload.set_any(anyArray);
            newEvent.setPayload(eventPayload);
        }
        return newEvent;
    }

    public static List<Event> getEventsUnmarshal(org.exoplatform.services.wsrp2.type.Event[] eventArray) {
        if (eventArray == null) {
            return null;
        }
        ArrayList<Event> eventsList = new ArrayList<Event>();
        int i = 0;
        for (org.exoplatform.services.wsrp2.type.Event event : eventArray) {
            Object obj = JAXBEventTransformer.getUnmarshalledObject(event.getType(), event.getPayload());
            if (obj == null) {
                try {
                    String clazz = event.getType().getLocalPart();
                    String pkg = clazz.substring(0, clazz.lastIndexOf("."));
                    ClassLoader cle = Thread.currentThread().getContextClassLoader();
                    MessageElement messageElement = event.getPayload().get_any()[0];
                    JAXBContext jaxb = JAXBContext.newInstance((String)pkg, (ClassLoader)cle);
                    Unmarshaller unmarshaller = jaxb.createUnmarshaller();
                    obj = unmarshaller.unmarshal((Node)messageElement);
                }
                catch (JAXBException je) {
                    je.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getEventsUnmarshal() o = " + obj));
            }
            EventImpl ev = new EventImpl(event.getName(), obj != null ? (Serializable)obj : null);
            eventsList.add((Event)ev);
            ++i;
        }
        return eventsList;
    }

    public static Document getMarshalledDocument(Object value, QName name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() value = " + value));
        }
        try {
            String toenum = value.getClass().getSimpleName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() toenum = " + toenum));
            }
            StandardClasses t = StandardClasses.valueOf(toenum.toUpperCase());
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getMarshalledDocument() t = " + (Object)((Object)t)));
            }
            return t.getMarshalledDocument(value, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getUnmarshalledObject(QName type, EventPayload payload) {
        try {
            String source = type.getLocalPart();
            String toenum = source.substring(source.lastIndexOf(".") + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getUnmarshalledObject() toenum = " + toenum));
            }
            StandardClasses t = StandardClasses.valueOf(toenum.toUpperCase());
            if (log.isDebugEnabled()) {
                log.debug((Object)("JAXBEventTransformer.getUnmarshalledObject() t = " + (Object)((Object)t)));
            }
            return t.getUnmarshalledObject(type, payload);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StandardClasses {
        STRING(new StandardPayload<T>()),
        BIGINTEGER(new StandardPayload<T>()),
        BIGDECIMAL(new StandardPayload<T>()),
        CALENDAR(new StandardPayload<T>()),
        DATE(new StandardPayload<T>()),
        QNAME(new StandardPayload<T>()),
        URI(new StandardPayload<T>()),
        XMLGREGORIANCALENDAR(new StandardPayload<T>()),
        DURATION(new StandardPayload<T>()),
        IMAGE(new StandardPayload<T>()),
        DATAHANDLER(new StandardPayload<T>()),
        SOURCE(new StandardPayload<T>()),
        UUID(new StandardPayload<T>());

        private StandardPayload<?> sp;

        private StandardClasses(StandardPayload<?> s) {
            this.sp = s;
        }

        public Document getMarshalledDocument(Object value, QName name) {
            return this.sp.getMarshalledDocument(value, name);
        }

        public Object getUnmarshalledObject(QName type, EventPayload payload) {
            return this.sp.getUnmarshalledObject(type, payload);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StandardPayload<T> {
            StandardPayload() {
            }

            public Document getMarshalledDocument(Object value, QName name) {
                Object val = value;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("StandardPayload.getMarshalledDocument() val.getClass() = " + val.getClass()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("StandardPayload.getMarshalledDocument() eventName.getLocalPart() = " + name.getLocalPart()));
                }
                try {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    JAXBElement valueWrapper = new JAXBElement(name, val.getClass(), val);
                    JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{val.getClass()});
                    Marshaller marshaller = jaxb.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.setProperty("jaxb.fragment", (Object)true);
                    marshaller.marshal((Object)valueWrapper, (Node)doc);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("StandardPayload.getMarshalledDocument() doc = " + doc));
                    }
                    return doc;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }

            public T getUnmarshalledObject(QName type, EventPayload payload) {
                MessageElement messageElement = payload.get_any()[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("StandardPayload.getUnmarshalledObject() messageElement = " + messageElement));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("StandardPayload.getUnmarshalledObject() type.getLocalPart() = " + type.getLocalPart()));
                }
                try {
                    JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{Class.forName(type.getLocalPart())});
                    Unmarshaller unmarshaller = jaxb.createUnmarshaller();
                    StringReader reader = new StringReader(messageElement.toString());
                    JAXBElement stdElement = unmarshaller.unmarshal((Source)new StreamSource(reader), Class.forName(type.getLocalPart()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("StandardPayload.getUnmarshalledObject() boolInput.getValue() = " + stdElement.getValue()));
                    }
                    return (T)stdElement.getValue();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            }
        }
    }
}

