/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.consumer.Producer;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_Markup_PortType;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_PortletManagement_PortType;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_Registration_PortType;
import org.exoplatform.services.wsrp2.intf.WSRP_v2_ServiceDescription_PortType;
import org.exoplatform.services.wsrp2.type.Deregister;
import org.exoplatform.services.wsrp2.type.GetServiceDescription;
import org.exoplatform.services.wsrp2.type.ModifyRegistration;
import org.exoplatform.services.wsrp2.type.PortletDescription;
import org.exoplatform.services.wsrp2.type.Register;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.RegistrationData;
import org.exoplatform.services.wsrp2.type.RegistrationState;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.ServiceDescription;
import org.exoplatform.services.wsrp2.wsdl.WSRPService;
import org.exoplatform.services.wsrp2.wsdl.WSRPServiceLocator;

public class ProducerImpl
implements Producer,
Serializable {
    private String name;
    private String ID;
    private String description;
    private String serviceDescriptionInterfaceEndpoint;
    private transient WSRP_v2_ServiceDescription_PortType serviceDescriptionInterface;
    private String markupInterfaceEndpoint;
    private transient WSRP_v2_Markup_PortType markupInterface;
    private String portletManagementInterfaceEndpoint;
    private transient WSRP_v2_PortletManagement_PortType portletManagementInterface;
    private String registrationInterfaceEndpoint;
    private ServiceDescription serviceDescription;
    private transient WSRP_v2_Registration_PortType registrationInterface;
    private boolean registrationRequired;
    private RegistrationData registrationData;
    private RegistrationContext registrationContext;
    private transient WSRPService service;
    private String[] desiredLocales;
    private transient Log log;

    public ProducerImpl(ExoContainer cont) {
        this.init(cont);
    }

    public void init(ExoContainer cont) {
        this.service = (WSRPService)cont.getComponentInstanceOfType(WSRPService.class);
        ((WSRPServiceLocator)this.service).setMaintainSession(true);
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
    }

    public String[] getDesiredLocales() {
        return this.desiredLocales;
    }

    public void setDesiredLocales(String[] desiredLocales) {
        this.desiredLocales = desiredLocales;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getServiceDescriptionInterfaceEndpoint() {
        return this.serviceDescriptionInterfaceEndpoint;
    }

    public void setServiceDescriptionInterfaceEndpoint(String serviceDescriptionInterfaceEndpoint) {
        this.serviceDescriptionInterfaceEndpoint = serviceDescriptionInterfaceEndpoint;
        this.serviceDescriptionInterface = null;
    }

    public WSRP_v2_ServiceDescription_PortType getServiceDescriptionInterface() {
        if (this.serviceDescriptionInterface == null) {
            try {
                try {
                    this.serviceDescriptionInterface = this.service.getWSRPServiceDescriptionService(new URL(this.serviceDescriptionInterfaceEndpoint));
                }
                catch (MalformedURLException e) {
                    this.log.debug((Object)("Malformed URL : " + this.serviceDescriptionInterfaceEndpoint));
                    this.serviceDescriptionInterface = this.service.getWSRPServiceDescriptionService();
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.serviceDescriptionInterface;
    }

    public ServiceDescription getServiceDescription(boolean newRequest) throws WSRPException {
        if (newRequest) {
            return this.getServiceDescription();
        }
        return this.serviceDescription;
    }

    public ServiceDescription getServiceDescription() throws WSRPException {
        if (this.desiredLocales == null) {
            throw new IllegalStateException("Desired locales field must be set");
        }
        if (this.serviceDescription == null) {
            this.updateServiceDescription();
        }
        return this.serviceDescription;
    }

    public PortletDescription getPortletDescription(String portletHandle) throws WSRPException {
        if (this.serviceDescription == null) {
            this.updateServiceDescription();
        }
        PortletDescription[] array = this.serviceDescription.getOfferedPortlets();
        for (int i = 0; i < array.length; ++i) {
            PortletDescription portletDescription = array[i];
            if (!portletDescription.getPortletHandle().equals(portletHandle)) continue;
            return portletDescription;
        }
        return null;
    }

    private void updateServiceDescription() {
        try {
            this.getServiceDescriptionInterface();
            GetServiceDescription getServiceDescription = this.getServiceDescription(this.desiredLocales);
            this.serviceDescription = this.serviceDescriptionInterface.getServiceDescription(getServiceDescription);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private GetServiceDescription getServiceDescription(String[] desiredLocales) {
        GetServiceDescription getServiceDescription = new GetServiceDescription();
        getServiceDescription.setRegistrationContext(this.registrationContext);
        getServiceDescription.setDesiredLocales(desiredLocales);
        return getServiceDescription;
    }

    public String getMarkupInterfaceEndpoint() {
        return this.markupInterfaceEndpoint;
    }

    public void setMarkupInterfaceEndpoint(String markupInterfaceEndpoint) {
        this.markupInterfaceEndpoint = markupInterfaceEndpoint;
    }

    public String getPortletManagementInterfaceEndpoint() {
        return this.portletManagementInterfaceEndpoint;
    }

    public void setPortletManagementInterfaceEndpoint(String portletManagementInterfaceEndpoint) {
        this.portletManagementInterfaceEndpoint = portletManagementInterfaceEndpoint;
        this.portletManagementInterface = null;
    }

    public WSRP_v2_PortletManagement_PortType getPortletManagementInterface() {
        if (this.portletManagementInterface == null) {
            try {
                try {
                    this.portletManagementInterface = this.service.getWSRPPortletManagementService(new URL(this.portletManagementInterfaceEndpoint));
                }
                catch (MalformedURLException e) {
                    this.portletManagementInterface = this.service.getWSRPPortletManagementService();
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.portletManagementInterface;
    }

    public boolean isPortletManagementInferfaceSupported() {
        if (this.portletManagementInterface == null) {
            this.getPortletManagementInterface();
        }
        return this.portletManagementInterface != null;
    }

    public String getRegistrationInterfaceEndpoint() {
        return this.registrationInterfaceEndpoint;
    }

    public void setRegistrationInterfaceEndpoint(String registrationInterfaceEndpoint) {
        this.registrationInterfaceEndpoint = registrationInterfaceEndpoint;
        this.registrationInterface = null;
    }

    public WSRP_v2_Registration_PortType getRegistrationInterface() {
        if (this.registrationInterface == null) {
            try {
                try {
                    this.registrationInterface = this.service.getWSRPRegistrationService(new URL(this.registrationInterfaceEndpoint));
                }
                catch (MalformedURLException e) {
                    this.registrationInterface = this.service.getWSRPRegistrationService();
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        return this.registrationInterface;
    }

    public boolean isRegistrationRequired() {
        if (this.serviceDescription == null) {
            this.updateServiceDescription();
        }
        return this.serviceDescription.isRequiresRegistration();
    }

    public RegistrationData getRegistrationData() {
        return this.registrationData;
    }

    public void setRegistrationData(RegistrationData registrationData) {
        this.registrationData = registrationData;
    }

    public RegistrationContext getRegistrationContext() throws WSRPException {
        return this.registrationContext;
    }

    public RegistrationContext register(Register register) throws WSRPException {
        if (this.registrationInterface == null) {
            this.getRegistrationInterface();
        }
        try {
            this.registrationContext = this.registrationInterface.register(register);
            this.registrationData = register.getRegistrationData();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return this.registrationContext;
    }

    public RegistrationState modifyRegistration(ModifyRegistration modifyRegistration) throws WSRPException {
        modifyRegistration.setRegistrationData(this.registrationData);
        modifyRegistration.setRegistrationContext(this.registrationContext);
        try {
            return this.registrationInterface.modifyRegistration(modifyRegistration);
        }
        catch (RemoteException e) {
            throw new WSRPException("InvalidRegistration", e);
        }
    }

    public ReturnAny deregister(Deregister deregister) throws WSRPException {
        if (this.registrationInterface == null) {
            this.getRegistrationInterface();
        }
        try {
            ReturnAny returnAny = this.registrationInterface.deregister(deregister);
            return returnAny;
        }
        catch (RemoteException e) {
            throw new WSRPException("InvalidRegistration", e);
        }
        finally {
            this.registrationContext = null;
            this.registrationData = null;
        }
    }

    public boolean isRegistrationInterfaceSupported() {
        if (this.serviceDescriptionInterface == null) {
            this.getServiceDescriptionInterface();
        }
        return this.serviceDescriptionInterface != null;
    }
}

