/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.adapters;

import org.exoplatform.services.wsrp2.consumer.WSRPBaseRequest;
import org.exoplatform.services.wsrp2.type.ClientData;
import org.exoplatform.services.wsrp2.type.Extension;
import org.exoplatform.services.wsrp2.type.NamedString;

public class WSRPBaseRequestAdapter
implements WSRPBaseRequest {
    private String sessionID;
    private String portletInstanceKey;
    private String navigationalState;
    private NamedString[] navigationalValues;
    private boolean secureClientCommunication;
    private String[] locales;
    private String[] mimeTypes;
    private String mode;
    private String windowState;
    private ClientData clientData;
    private String[] markupCharacterSets;
    private String validateTag;
    private String[] validNewModes;
    private String[] validNewWindowStates;
    private Extension[] extensions;
    private String userAuthentication;

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getPortletInstanceKey() {
        return this.portletInstanceKey;
    }

    public void setPortletInstanceKey(String portletInstanceKey) {
        this.portletInstanceKey = portletInstanceKey;
    }

    public String getNavigationalState() {
        return this.navigationalState;
    }

    public void setNavigationalState(String navigationalState) {
        this.navigationalState = navigationalState;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public ClientData getClientData() {
        return this.clientData;
    }

    public void setClientData(ClientData clientData) {
        this.clientData = clientData;
    }

    public String[] getLocales() {
        return this.locales;
    }

    public void setLocales(String[] locales) {
        this.locales = locales;
    }

    public String[] getValidNewModes() {
        return this.validNewModes;
    }

    public void setValidNewModes(String[] validNewModes) {
        this.validNewModes = validNewModes;
    }

    public String[] getValidNewWindowStates() {
        return this.validNewWindowStates;
    }

    public void setValidNewWindowStates(String[] validNewWindowStates) {
        this.validNewWindowStates = validNewWindowStates;
    }

    public String[] getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(String[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String[] getMarkupCharacterSets() {
        return this.markupCharacterSets;
    }

    public void setMarkupCharacterSets(String[] markupCharacterSets) {
        this.markupCharacterSets = markupCharacterSets;
    }

    public boolean isModeSupported(String wsrpMode) {
        if (wsrpMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        String[] mods = this.getValidNewModes();
        for (int i = 0; i < mods.length; ++i) {
            if (!wsrpMode.equalsIgnoreCase(mods[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowStateSupported(String wsrpWindowState) {
        if (wsrpWindowState == null) {
            throw new IllegalArgumentException("window state must not be null");
        }
        String[] stats = this.getValidNewWindowStates();
        for (int i = 0; i < stats.length; ++i) {
            if (!wsrpWindowState.equalsIgnoreCase(stats[i])) continue;
            return true;
        }
        return false;
    }

    public NamedString[] getNavigationalValues() {
        return this.navigationalValues;
    }

    public void setNavigationalValues(NamedString[] navigationalValues) {
        this.navigationalValues = navigationalValues;
    }

    public String getValidateTag() {
        return this.validateTag;
    }

    public void setValidateTag(String validateTag) {
        this.validateTag = validateTag;
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Extension[] extensions) {
        this.extensions = extensions;
    }

    public boolean isSecureClientCommunication() {
        return this.secureClientCommunication;
    }

    public void setSecureClientCommunication(boolean secureClientCommunication) {
        this.secureClientCommunication = secureClientCommunication;
    }

    public String getUserAuthentication() {
        return this.userAuthentication;
    }

    public void setUserAuthentication(String userAuthentication) {
        this.userAuthentication = userAuthentication;
    }
}

