/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.wsrp2.consumer.PortletDriver;
import org.exoplatform.services.wsrp2.consumer.PortletDriverRegistry;
import org.exoplatform.services.wsrp2.consumer.WSRPPortlet;
import org.exoplatform.services.wsrp2.consumer.impl.PortletDriverImpl;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDriverRegistryImpl
implements PortletDriverRegistry {
    private Map<String, PortletDriver> portletDrivers = new HashMap<String, PortletDriver>();
    protected ExoContainer cont;

    public PortletDriverRegistryImpl(ExoContainerContext ctx) {
        this.cont = ctx.getContainer();
    }

    @Override
    public PortletDriver getPortletDriver(WSRPPortlet portlet) throws WSRPException {
        PortletDriver driver = this.portletDrivers.get(portlet.getPortletKey().toString());
        if (driver == null) {
            driver = new PortletDriverImpl(this.cont, portlet);
            this.portletDrivers.put(portlet.getPortletKey().toString(), driver);
        }
        return driver;
    }

    @Override
    public Iterator<PortletDriver> getAllPortletDrivers() {
        return this.portletDrivers.values().iterator();
    }
}

