/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.consumer.URLGenerator;
import org.exoplatform.services.wsrp2.consumer.URLRewriter;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLRewriterImpl
implements URLRewriter {
    private URLGenerator urlGenerator;
    private Log log;

    public URLRewriterImpl(URLGenerator urlGenerator) {
        this.urlGenerator = urlGenerator;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2.consumer");
    }

    @Override
    public String rewriteURLs(String baseURL, String markup) throws WSRPException {
        this.log.debug((Object)("Rewrite URL : " + markup));
        StringBuffer resultMarkup = new StringBuffer();
        int processIndex = 0;
        int rewriteStartPos = -1;
        int rewriteEndPos = -1;
        while (processIndex < markup.length()) {
            rewriteStartPos = -1;
            rewriteEndPos = -1;
            rewriteStartPos = markup.indexOf("wsrp_rewrite?", processIndex);
            if (rewriteStartPos == -1 || (rewriteEndPos = markup.indexOf("/wsrp_rewrite", rewriteStartPos + "wsrp_rewrite?".length())) == -1) break;
            resultMarkup.append(markup.substring(processIndex, rewriteStartPos));
            String toRewriteURL = markup.substring(rewriteStartPos + "wsrp_rewrite?".length(), (rewriteEndPos += "/wsrp_rewrite".length()) - "/wsrp_rewrite".length());
            resultMarkup.append(this.getRewrittenURL(baseURL, toRewriteURL));
            processIndex = rewriteEndPos;
        }
        resultMarkup.append(markup.substring(processIndex));
        this.log.debug((Object)("Markup returned : " + resultMarkup.toString()));
        return resultMarkup.toString();
    }

    private String getRewrittenURL(String baseURL, String toRewriteURL) throws WSRPException {
        if (!toRewriteURL.startsWith("wsrp-urlType=")) {
            return toRewriteURL;
        }
        toRewriteURL = toRewriteURL.substring("wsrp-urlType=".length());
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (toRewriteURL.startsWith("blockingAction")) {
            params.put("portal:type", "action");
            toRewriteURL = toRewriteURL.substring("blockingAction".length() + 1);
            this.fillParameterMap(params, toRewriteURL);
            return this.urlGenerator.getBlockingActionURL(baseURL, params);
        }
        if (toRewriteURL.startsWith("render")) {
            params.put("portal:type", "render");
            toRewriteURL = toRewriteURL.substring("render".length() + 1);
            this.fillParameterMap(params, toRewriteURL);
            return this.urlGenerator.getRenderURL(baseURL, params);
        }
        if (toRewriteURL.startsWith("resource")) {
            params.put("portal:type", "resource");
            toRewriteURL = toRewriteURL.substring("resource".length() + 1);
            this.fillParameterMap(params, toRewriteURL);
            return this.urlGenerator.getResourceURL(baseURL, params);
        }
        params.put("portal:type", toRewriteURL.substring(0, toRewriteURL.indexOf("&") - 1));
        toRewriteURL = toRewriteURL.substring(toRewriteURL.indexOf("&"));
        this.fillParameterMap(params, toRewriteURL);
        return this.urlGenerator.getExtensionURL(baseURL, params);
    }

    private void fillParameterMap(Map<String, String> params, String toRewriteURL) throws WSRPException {
        String[] parameterPairs;
        for (String string : parameterPairs = toRewriteURL.split("&")) {
            String[] nameAndValue = string.split("=");
            if (nameAndValue[0].startsWith("&".substring(1))) {
                nameAndValue[0] = nameAndValue[0].substring("&".substring(1).length());
            }
            if (nameAndValue.length == 1) {
                params.put(nameAndValue[0], "");
                continue;
            }
            params.put(nameAndValue[0], nameAndValue[1]);
        }
    }
}

