/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;
import org.exoplatform.services.wsrp2.producer.RegistrationOperationsInterface;
import org.exoplatform.services.wsrp2.producer.impl.helpers.Helper;
import org.exoplatform.services.wsrp2.type.Lifetime;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.RegistrationData;
import org.exoplatform.services.wsrp2.type.RegistrationState;
import org.exoplatform.services.wsrp2.type.ReturnAny;
import org.exoplatform.services.wsrp2.type.UserContext;

public class RegistrationOperationsInterfaceImp
implements RegistrationOperationsInterface {
    private Log log;
    private PersistentStateManager stateManager;

    public RegistrationOperationsInterfaceImp(PersistentStateManager stateManager) {
        this.stateManager = stateManager;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
    }

    public RegistrationContext register(RegistrationData data, UserContext userContext, Lifetime lifetime) throws RemoteException {
        if (Helper.lifetimeExpired(lifetime)) {
            Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
        }
        String owner = null;
        if (userContext != null) {
            owner = userContext.getUserContextKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Register method entered for user:" + owner));
            }
        }
        String registrationHandle = null;
        byte[] registrationState = null;
        try {
            this.validateRegistrationDatas(data);
            registrationHandle = IdentifierUtil.generateUUID((Object)data);
            registrationState = this.stateManager.register(registrationHandle, data);
            this.stateManager.putRegistrationLifetime(registrationHandle, lifetime);
        }
        catch (WSRPException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Registration failed", (Throwable)e);
            }
            Exception2Fault.handleException(e);
        }
        RegistrationContext rC = new RegistrationContext();
        rC.setRegistrationHandle(registrationHandle);
        rC.setRegistrationState(registrationState);
        rC.setScheduledDestruction(lifetime);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registration done with handle : " + registrationHandle + " for owner : " + owner));
        }
        return rC;
    }

    public RegistrationState modifyRegistration(RegistrationContext registrationContext, RegistrationData data, UserContext userContext) throws RemoteException {
        if (userContext != null) {
            String owner = userContext.getUserContextKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Modify registrion method entered for owner " + owner));
            }
        }
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String registrationHandle = registrationContext.getRegistrationHandle();
        try {
            this.validateRegistrationDatas(data);
            byte[] registrationState = this.stateManager.register(registrationHandle, data);
        }
        catch (WSRPException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Registration failed", (Throwable)e);
            }
            Exception2Fault.handleException(e);
        }
        return new RegistrationState();
    }

    public ReturnAny deregister(RegistrationContext registrationContext, UserContext userContext) throws RemoteException {
        if (userContext != null) {
            String owner = userContext.getUserContextKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deregister method entered for owner:" + owner));
            }
        }
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        try {
            this.stateManager.deregister(registrationContext);
        }
        catch (WSRPException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Registration failed", (Throwable)e);
            }
            Exception2Fault.handleException(e);
        }
        return new ReturnAny();
    }

    public Lifetime getRegistrationLifetime(RegistrationContext registrationContext, UserContext userContext) throws RemoteException {
        if (userContext != null) {
            String owner = userContext.getUserContextKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getRegistrationLifetime method entered for owner:" + owner));
            }
        }
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        Lifetime lifetime = null;
        try {
            lifetime = this.stateManager.getRegistrationLifetime(registrationContext);
        }
        catch (WSRPException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Get registration lifetime failed", (Throwable)e);
            }
            Exception2Fault.handleException(e);
        }
        return lifetime;
    }

    public Lifetime setRegistrationLifetime(RegistrationContext registrationContext, UserContext userContext, Lifetime lifetime) throws RemoteException {
        if (userContext != null) {
            String owner = userContext.getUserContextKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getRegistrationLifetime method entered for owner:" + owner));
            }
        }
        try {
            if (!this.stateManager.isRegistered(registrationContext)) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        Lifetime resultLifetime = null;
        try {
            resultLifetime = this.stateManager.putRegistrationLifetime(registrationContext.getRegistrationHandle(), lifetime);
        }
        catch (WSRPException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Get registration lifetime failed", (Throwable)e);
            }
            Exception2Fault.handleException(e);
        }
        return resultLifetime;
    }

    private void validateRegistrationDatas(RegistrationData data) throws WSRPException {
        String consumerAgent = data.getConsumerAgent();
        String[] members = StringUtils.split((String)consumerAgent, (String)".");
        if (!StringUtils.isNumeric((String)members[1])) {
            throw new WSRPException("MissingParameters");
        }
        if (!StringUtils.isNumeric((String)members[2])) {
            throw new WSRPException("MissingParameters");
        }
    }
}

