/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl.helpers;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletURLImp;
import org.exoplatform.services.wsrp2.exceptions.WSRPException;
import org.exoplatform.services.wsrp2.producer.PersistentStateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerRewriterPortletURLImp
extends PortletURLImp {
    private String sessionID;
    private String portletHandle;
    private PersistentStateManager stateManager;
    private List<String> supportedPublicRenderParameter;

    public ProducerRewriterPortletURLImp(String type, String template, String markup, List<Supports> supports, boolean isCurrentlySecured, String portletHandle, PersistentStateManager stateManager, String sessionID, boolean defaultEscapeXml, List<String> supportedPublicRenderParameter, Portlet portlet) {
        super(type, template, markup, supports, isCurrentlySecured, defaultEscapeXml, portlet);
        this.portletHandle = portletHandle;
        this.stateManager = stateManager;
        this.sessionID = sessionID;
        this.supportedPublicRenderParameter = supportedPublicRenderParameter;
    }

    public String toString() {
        if (this.getType().equals("blockingAction")) {
            this.invokeFilterActionURL();
        } else {
            this.invokeFilterRenderURL();
        }
        HashMap<String, String[]> publicParams = new HashMap<String, String[]>();
        HashMap<String, String[]> privateParams = new HashMap<String, String[]>();
        String navigationalValuesString = new String();
        if (this.parameters != null) {
            Set keys = this.parameters.keySet();
            for (String key : keys) {
                String[] value = (String[])this.parameters.get(key);
                if (this.supportedPublicRenderParameter != null && this.supportedPublicRenderParameter.contains(key)) {
                    publicParams.put(key, value);
                    for (String param : value) {
                        if (navigationalValuesString != "") {
                            navigationalValuesString = navigationalValuesString + "&";
                        }
                        navigationalValuesString = navigationalValuesString + key + "=" + param;
                    }
                    continue;
                }
                privateParams.put(key, value);
            }
        }
        String template = this.baseURL;
        template = StringUtils.replace((String)template, (String)"{wsrp-urlType}", (String)this.getType());
        template = StringUtils.replace((String)template, (String)"{wsrp-fragmentID}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-extensions}", (String)"");
        String secureInfo = "false";
        if (!this.isSetSecureCalled() && this.isCurrentlySecured()) {
            this.setSecure(true);
            secureInfo = "true";
        }
        template = StringUtils.replace((String)template, (String)"{wsrp-secureURL}", (String)secureInfo);
        template = this.requiredPortletMode != null ? StringUtils.replace((String)template, (String)"{wsrp-mode}", (String)this.requiredPortletMode.toString()) : StringUtils.replace((String)template, (String)"{wsrp-mode}", (String)"");
        template = this.requiredWindowState != null ? StringUtils.replace((String)template, (String)"{wsrp-windowState}", (String)this.requiredWindowState.toString()) : StringUtils.replace((String)template, (String)"{wsrp-windowState}", (String)"");
        String navigationalState = IdentifierUtil.generateUUID((Object)((Object)this));
        try {
            this.stateManager.putNavigationalState(navigationalState, this.parameters);
        }
        catch (WSRPException e) {
            e.printStackTrace();
        }
        template = StringUtils.replace((String)template, (String)"{wsrp-navigationalState}", (String)navigationalState);
        template = StringUtils.replace((String)template, (String)"{wsrp-navigationalValues}", (String)this.encode(navigationalValuesString));
        if (this.getType().equalsIgnoreCase("action")) {
            String interactionState = IdentifierUtil.generateUUID((Object)((Object)this));
            try {
                this.stateManager.putInteractionState(interactionState, this.parameters);
            }
            catch (WSRPException e) {
                e.printStackTrace();
            }
            template = StringUtils.replace((String)template, (String)"{wsrp-interactionState}", (String)interactionState);
        } else {
            template = StringUtils.replace((String)template, (String)"{wsrp-interactionState}", (String)"");
        }
        template = StringUtils.replace((String)template, (String)"{wsrp-url}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-resourceID}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-resourceState}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-resourceCacheability}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-requiresRewrite}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-preferOperation}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-portletHandle}", (String)this.portletHandle);
        template = StringUtils.replace((String)template, (String)"{wsrp-userContextKey}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-portletInstanceKey}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-sessionID}", (String)this.sessionID);
        template = StringUtils.replace((String)template, (String)"{wsrp-pageState}", (String)"");
        template = StringUtils.replace((String)template, (String)"{wsrp-portletStates}", (String)"");
        Set names = this.parameters.keySet();
        for (String name : names) {
            Object obj = this.parameters.get(name);
            if (obj instanceof String) {
                String value = (String)obj;
                template = template + "&";
                template = template + this.encode(name);
                template = template + "=";
                template = template + this.encode(value);
                continue;
            }
            String[] values = (String[])obj;
            for (int i = 0; i < values.length; ++i) {
                template = template + "&";
                template = template + this.encode(name);
                template = template + "=";
                template = template + this.encode(values[i]);
            }
        }
        return template;
    }
}

