/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.wsrp2.type.Extension;
import org.exoplatform.services.wsrp2.type.LocalizedString;
import org.exoplatform.services.wsrp2.type.NamedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String getStringFromLocalizedString(LocalizedString ls) {
        if (ls != null) {
            return ls.getValue();
        }
        return null;
    }

    public static LocalizedString getLocalizedString(String value, String lang, String rn) {
        LocalizedString tmp = new LocalizedString();
        tmp.setValue(value);
        tmp.setResourceName(rn);
        return tmp;
    }

    public static LocalizedString getLocalizedString(String value, String lang) {
        LocalizedString tmp = new LocalizedString();
        tmp.setValue(value);
        return tmp;
    }

    public static NamedString getNamesString(String name, String value) {
        NamedString tmp = new NamedString();
        tmp.setName(name);
        tmp.setValue(value);
        return tmp;
    }

    public static QName[] getQNameArray(List<QName> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new QName[0];
        }
        QName[] result = list.toArray(new QName[0]);
        return result;
    }

    public static List<QName> getQNameList(QName[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return new ArrayList<QName>();
        }
        List<QName> result = Arrays.asList(array);
        return result;
    }

    public static String changeUrlTypeFromJSRPortletToWSRP(String type) {
        if (type.equalsIgnoreCase("action")) {
            return "blockingAction";
        }
        if (type.equalsIgnoreCase("resource")) {
            return "resource";
        }
        if (type.equalsIgnoreCase("render")) {
            return "render";
        }
        return type;
    }

    public static String changeUrlTypeFromWSRPToJSRPortlet(String type) {
        if (type.equalsIgnoreCase("blockingAction")) {
            return "action";
        }
        if (type.equalsIgnoreCase("resource")) {
            return "resource";
        }
        if (type.equalsIgnoreCase("render")) {
            return "render";
        }
        return type;
    }

    @Deprecated
    public static void fillExtensions(String temp, Extension[] extensions) {
        if (extensions != null && extensions[0] != null && extensions[0].get_any() != null) {
            if (extensions[0].get_any()[0] != null) {
                try {
                    temp = StringUtils.replace((String)temp, (String)"{wsrp-extensions}", (String)extensions[0].get_any()[0].getAsString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                temp = StringUtils.replace((String)temp, (String)"{wsrp-extensions}", (String)"");
            }
        }
    }

    public static NamedString[] getNamedStringArrayParametersFromMap(Map<String, String[]> params) {
        return Utils.getNamedStringArrayParametersFromMap(params, false);
    }

    public static NamedString[] getNamedStringArrayParametersFromMap(Map<String, String[]> params, boolean selectOnlyNonWSRP) {
        if (params == null) {
            return null;
        }
        if (params.isEmpty()) {
            return new NamedString[0];
        }
        Set<String> keys = params.keySet();
        ArrayList<NamedString> listNamedStringParams = new ArrayList<NamedString>();
        for (String name : keys) {
            String[] values;
            if ((!selectOnlyNonWSRP || name.startsWith("wsrp-")) && selectOnlyNonWSRP) continue;
            for (String value : values = params.get(name)) {
                listNamedStringParams.add(Utils.getNamesString(name, value));
            }
        }
        return listNamedStringParams.toArray(new NamedString[listNamedStringParams.size()]);
    }

    public static Map<String, String[]> getMapParametersFromNamedStringArray(NamedString[] array) {
        if (array == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (array != null) {
            for (NamedString namedString : array) {
                String name = namedString.getName();
                String value = namedString.getValue();
                if (value == null) continue;
                if (result.get(name) == null) {
                    result.put(name, new String[]{value});
                    continue;
                }
                Arrays.asList((Object[])result.get(name)).add(value);
            }
        }
        return result;
    }
}

