/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wsrp2.consumer.Producer;
import org.exoplatform.services.wsrp2.consumer.ProducerRegistry;
import org.exoplatform.services.wsrp2.consumer.impl.ProducerImpl;
import org.exoplatform.services.wsrp2.consumer.impl.WSRP2ProducerData;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerRegistryImpl
implements ProducerRegistry {
    private static final String queryAllProducer = "from pd in class org.exoplatform.services.wsrp2.consumer.impl.WSRP2ProducerData";
    private static final String queryProducer = "from pd in class org.exoplatform.services.wsrp2.consumer.impl.WSRP2ProducerData where pd.id = ?";
    private long lastModifiedTime_;
    private Map<String, Producer> producers;
    private HibernateService hservice_;
    private Log log_;
    protected ExoContainer cont;

    public ProducerRegistryImpl(ExoContainerContext ctx, HibernateService dbService) throws ConfigurationException {
        this.hservice_ = dbService;
        this.log_ = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
        this.cont = ctx.getContainer();
        this.producers = this.loadProducers();
        this.lastModifiedTime_ = System.currentTimeMillis();
    }

    private Map<String, Producer> loadProducers() {
        HashMap<String, Producer> map = new HashMap<String, Producer>();
        try {
            Collection<WSRP2ProducerData> c = this.loadAll();
            for (WSRP2ProducerData wsrp2ProducerData : c) {
                ((ProducerImpl)wsrp2ProducerData.getProducer()).init(this.cont);
                map.put(wsrp2ProducerData.getId(), wsrp2ProducerData.getProducer());
            }
        }
        catch (Exception e) {
            this.log_.error((Object)"Error", (Throwable)e);
        }
        return map;
    }

    @Override
    public void addProducer(Producer producer) {
        try {
            this.save(producer);
            this.producers.put(producer.getID(), producer);
            this.lastModifiedTime_ = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Producer getProducer(String id) {
        return this.producers.get(id);
    }

    @Override
    public Iterator<Producer> getAllProducers() {
        return this.producers.values().iterator();
    }

    @Override
    public Producer removeProducer(String id) {
        try {
            this.remove(id);
            this.producers.remove(id);
            this.lastModifiedTime_ = System.currentTimeMillis();
            Producer producer = this.producers.get(id);
            return producer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void removeAllProducers() throws Exception {
        this.removeAll();
        this.producers.clear();
        this.lastModifiedTime_ = System.currentTimeMillis();
    }

    @Override
    public boolean existsProducer(String id) {
        return this.producers.containsKey(id);
    }

    @Override
    public Producer createProducerInstance() {
        return new ProducerImpl(this.cont);
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime_;
    }

    public final void save(Producer p) throws Exception {
        Session session = this.hservice_.openSession();
        WSRP2ProducerData data = this.load(p.getID());
        if (data == null) {
            data = new WSRP2ProducerData();
            data.setId(p.getID());
            data.setProducer(p);
            session.save((Object)data);
        } else {
            data.setProducer(p);
            session.update((Object)data);
        }
        session.flush();
    }

    public final Collection<WSRP2ProducerData> loadAll() throws Exception {
        Session session = this.hservice_.openSession();
        return session.createQuery(queryAllProducer).list();
    }

    public final WSRP2ProducerData load(String id) throws Exception {
        Session session = this.hservice_.openSession();
        WSRP2ProducerData data = this.load(id, session);
        return data;
    }

    public final WSRP2ProducerData load(String id, Session session) throws Exception {
        WSRP2ProducerData data = null;
        List l = session.createQuery(queryProducer).setString(0, id).list();
        if (l.size() > 1) {
            throw new Exception("Expect only one configuration but found" + l.size());
        }
        if (l.size() == 1) {
            data = (WSRP2ProducerData)l.get(0);
        }
        return data;
    }

    public final void remove(String id) throws Exception {
        Session session = this.hservice_.openSession();
        Object obj = session.createQuery(queryProducer).setString(0, id).uniqueResult();
        session.delete(obj);
        session.flush();
    }

    public final void removeAll() throws Exception {
        Session session = this.hservice_.openSession();
        List c = session.createQuery(queryAllProducer).list();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            session.delete(iterator.next());
        }
        session.flush();
    }
}

