/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.consumer.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.wsrp2.consumer.URLGenerator;
import org.exoplatform.services.wsrp2.utils.Modes;
import org.exoplatform.services.wsrp2.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLGeneratorImpl
implements URLGenerator {
    @Override
    public String getBlockingActionURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    @Override
    public String getRenderURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    @Override
    public String getResourceURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    @Override
    public String getExtensionURL(String baseURL, Map<String, String> params) {
        return this.getURL(baseURL, params);
    }

    private String getURL(String baseURL, Map<String, String> params) {
        StringBuffer sB = new StringBuffer();
        sB.append(baseURL);
        return this.computeParameters(sB, params);
    }

    @Override
    public String getNamespacedToken(String token) {
        return token;
    }

    private String computeParameters(StringBuffer sB, Map<String, String> parameters) {
        Set<String> names = parameters.keySet();
        for (String name : names) {
            String value = parameters.get(name);
            if ("wsrp-portletHandle".equals(name)) continue;
            sB.append("&");
            sB.append(this.replaceName(name));
            sB.append("=");
            sB.append(this.replaceValue(name, value));
        }
        return sB.toString();
    }

    private String replaceName(String name) {
        if ("wsrp-portletHandle".equals(name)) {
            return "portal:componentId";
        }
        if ("wsrp-urlType".equals(name)) {
            return "portal:type";
        }
        if ("wsrp-mode".equals(name)) {
            return "portal:portletMode";
        }
        if ("wsrp-windowState".equals(name)) {
            return "portal:windowState";
        }
        if ("wsrp-secureURL".equals(name)) {
            return "portal:isSecure";
        }
        return name;
    }

    private String replaceValue(String name, String value) {
        if ("wsrp-portletHandle".equals(name)) {
            return value;
        }
        if ("wsrp-urlType".equals(name)) {
            if ("blockingAction".equals(value)) {
                value = "action";
            }
            return value;
        }
        if ("wsrp-mode".equals(name)) {
            return Modes.delAllPrefixWSRP(value);
        }
        if ("wsrp-windowState".equals(name)) {
            return WindowStates.delAllPrefixWSRP(value);
        }
        if ("wsrp-secureURL".equals(name)) {
            return value;
        }
        return value;
    }

    protected String encode(String s, boolean escapeXML) {
        if (escapeXML) {
            s = this.encodeChars(s);
        }
        try {
            return URLEncoder.encode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    protected String encodeChars(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&#034;").replace("'", "&#039;");
    }
}

