/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.pci.CustomModeWithDescription;
import org.exoplatform.services.portletcontainer.pci.CustomWindowStateWithDescription;
import org.exoplatform.services.portletcontainer.pci.LocalisedDescription;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.EventDefinition;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.wsrp2.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp2.producer.ServiceDescriptionInterface;
import org.exoplatform.services.wsrp2.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp2.type.CookieProtocol;
import org.exoplatform.services.wsrp2.type.EventDescription;
import org.exoplatform.services.wsrp2.type.ItemDescription;
import org.exoplatform.services.wsrp2.type.ModelDescription;
import org.exoplatform.services.wsrp2.type.PortletDescription;
import org.exoplatform.services.wsrp2.type.RegistrationContext;
import org.exoplatform.services.wsrp2.type.ResourceList;
import org.exoplatform.services.wsrp2.type.ServiceDescription;
import org.exoplatform.services.wsrp2.type.UserContext;
import org.exoplatform.services.wsrp2.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionInterfaceImpl
implements ServiceDescriptionInterface {
    private PortletContainerProxy proxy;
    public static String[] localesArray = new String[]{"en", "fr"};
    private WSRPConfiguration conf;
    private Log log;
    private ExoContainer container;
    private PortletContainerConf pcConf;
    private PortletApplicationsHolder pcHolder;

    public ServiceDescriptionInterfaceImpl(PortletContainerProxy cont, WSRPConfiguration conf, ExoContainerContext context) {
        this.proxy = cont;
        this.conf = conf;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp2");
        this.container = context.getContainer();
        this.pcConf = (PortletContainerConf)this.container.getComponentInstanceOfType(PortletContainerConf.class);
        this.pcHolder = (PortletApplicationsHolder)this.container.getComponentInstanceOfType(PortletApplicationsHolder.class);
    }

    @Override
    public ServiceDescription getServiceDescription(RegistrationContext registrationContext, String[] desiredLocales) throws RemoteException {
        if (desiredLocales == null) {
            desiredLocales = new String[]{"en", "fr"};
        }
        this.log.debug((Object)("getServiceDescription entered with registrationContext : " + registrationContext));
        Map<String, PortletData> portletMetaDatas = this.proxy.getAllPortletMetaData();
        Set<String> keys = portletMetaDatas.keySet();
        HashSet<String> keys2 = new HashSet<String>(keys);
        if (this.conf.getExcludeList() != null) {
            for (String handle : this.conf.getExcludeList()) {
                if (handle.endsWith("*")) {
                    for (String object : keys2) {
                        if (!object.startsWith(handle.substring(0, handle.length() - 1))) continue;
                        keys.remove(object);
                    }
                    continue;
                }
                if (!keys.contains(handle)) continue;
                keys.remove(handle);
            }
        }
        PortletDescription[] pdescription = new PortletDescription[keys.size()];
        int i = 0;
        for (String producerOfferedPortletHandle : keys) {
            this.log.debug((Object)("fill service description with portlet description: " + producerOfferedPortletHandle));
            pdescription[i] = this.proxy.getPortletDescription(producerOfferedPortletHandle, desiredLocales);
            ++i;
        }
        ServiceDescription sD = new ServiceDescription();
        sD.setRequiresRegistration(this.conf.isRegistrationRequired());
        sD.setRegistrationPropertyDescription(new ModelDescription());
        sD.setRequiresInitCookie(CookieProtocol.none);
        sD.setCustomModeDescriptions(this.getCustomModeDescriptions(this.pcConf.getSupportedPortletModesWithDescriptions()));
        sD.setCustomWindowStateDescriptions(this.getCustomWindowStateDescriptions(this.pcConf.getSupportedWindowStatesWithDescriptions()));
        sD.setLocales(localesArray);
        sD.setOfferedPortlets(pdescription);
        sD.setResourceList(new ResourceList());
        sD.setExtensionDescriptions(null);
        sD.setEventDescriptions(this.getEventDescriptions());
        sD.setSupportedOptions(new String[]{"wsrp:events", "wsrp:leasing", "wsrp:copyPortlets", "wsrp:import", "wsrp:export"});
        sD.setExportDescription(null);
        sD.setMayReturnRegistrationState(null);
        sD.setSchemaType(null);
        return sD;
    }

    private EventDescription[] getEventDescriptions() {
        ArrayList<EventDescription> eventDescriptions = new ArrayList<EventDescription>();
        List portletApps = this.pcHolder.getPortletAppList();
        for (PortletApp portletApp : portletApps) {
            List eventDefinitions = portletApp.getEventDefinition();
            for (EventDefinition eventDefinition : eventDefinitions) {
                EventDescription ed = new EventDescription();
                ed.setName(eventDefinition.getPrefferedName());
                ed.setAliases(Utils.getQNameArray(eventDefinition.getAliases()));
                if (eventDefinition.getDescription() != null && !eventDefinition.getDescription().isEmpty()) {
                    Description d = (Description)eventDefinition.getDescription().get(0);
                    ed.setDescription(Utils.getLocalizedString(d.getDescription(), "en"));
                }
                ed.setSchemaLocation(null);
                if (eventDefinition.getJavaClass() != null && !"".equals(eventDefinition.getJavaClass())) {
                    ed.setType(new QName(eventDefinition.getJavaClass()));
                }
                ed.setSchemaType(null);
                ed.setLabel(null);
                ed.setHint(null);
                ed.setExtensions(null);
                eventDescriptions.add(ed);
            }
        }
        return eventDescriptions.toArray(new EventDescription[0]);
    }

    @Override
    public ServiceDescription getServiceDescription(RegistrationContext registrationContext, String[] desiredLocales, String[] portletHandles, UserContext userContext) throws RemoteException {
        if (desiredLocales == null) {
            desiredLocales = new String[]{"en", "fr"};
        }
        this.log.debug((Object)("getServiceDescription entered with registrationContext : " + registrationContext));
        Map<String, PortletData> portletMetaDatas = this.proxy.getAllPortletMetaData();
        Set<String> keys = portletMetaDatas.keySet();
        if (this.conf.getExcludeList() != null) {
            for (String handle : this.conf.getExcludeList()) {
                if (!keys.contains(handle)) continue;
                keys.remove(handle);
            }
        }
        int n = 0;
        for (String keysHandle : keys) {
            boolean found = false;
            for (int k = 0; k < portletHandles.length; ++k) {
                if (!portletHandles[k].equals(keysHandle)) continue;
                found = true;
                break;
            }
            if (!found) {
                keys.remove(keysHandle);
            }
            ++n;
        }
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        PortletDescription[] pdescription = new PortletDescription[keys.size()];
        int i = 0;
        for (String producerOfferedPortletHandle : keys) {
            this.log.debug((Object)"fill service description with portlet description ");
            pdescription[i] = this.proxy.getPortletDescription(producerOfferedPortletHandle, desiredLocales);
            ++i;
        }
        ServiceDescription sD = new ServiceDescription();
        sD.setRequiresRegistration(this.conf.isRegistrationRequired());
        sD.setRegistrationPropertyDescription(new ModelDescription());
        sD.setRequiresInitCookie(CookieProtocol.none);
        sD.setCustomModeDescriptions(this.getCustomModeDescriptions(this.pcConf.getSupportedPortletModesWithDescriptions()));
        sD.setCustomWindowStateDescriptions(this.getCustomWindowStateDescriptions(this.pcConf.getSupportedWindowStatesWithDescriptions()));
        sD.setLocales(localesArray);
        sD.setOfferedPortlets(pdescription);
        sD.setResourceList(new ResourceList());
        sD.setSchemaType(null);
        return sD;
    }

    private ItemDescription[] getCustomWindowStateDescriptions(Collection<CustomWindowStateWithDescription> collection) {
        ArrayList<ItemDescription> c = new ArrayList<ItemDescription>();
        for (CustomWindowStateWithDescription element : collection) {
            List l = element.getDescriptions();
            ItemDescription iD = null;
            for (LocalisedDescription d : l) {
                iD = new ItemDescription();
                iD.setItemName(element.getWindowState().toString());
                iD.setDescription(Utils.getLocalizedString(d.getDescription(), d.getLocale().getLanguage()));
                c.add(iD);
            }
        }
        ItemDescription[] iDTab = new ItemDescription[c.size()];
        int i = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iDTab[i] = (ItemDescription)iter.next();
            ++i;
        }
        return iDTab;
    }

    private ItemDescription[] getCustomModeDescriptions(Collection<CustomModeWithDescription> collection) {
        ArrayList<ItemDescription> c = new ArrayList<ItemDescription>();
        for (CustomModeWithDescription element : collection) {
            List l = element.getDescriptions();
            ItemDescription iD = null;
            for (LocalisedDescription d : l) {
                iD = new ItemDescription();
                iD.setItemName(element.getPortletMode().toString());
                iD.setDescription(Utils.getLocalizedString(d.getDescription(), d.getLocale().getLanguage()));
                c.add(iD);
            }
        }
        ItemDescription[] iDTab = new ItemDescription[c.size()];
        int i = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iDTab[i] = (ItemDescription)iter.next();
            ++i;
        }
        return iDTab;
    }
}

