/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp2.producer.impl.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRPHttpServletRequest
implements HttpServletRequest {
    private HttpSession session;
    private Map<String, String[]> parameters;
    private Map<String, Object> attributes;
    private String scheme;
    private String serverName;
    private int serverPort;
    private String characterEncoding;
    private Locale locale;
    private Enumeration<Locale> locales;
    private String protocol;
    public static String WSRP_CONTAINER = "portal";
    private ExoContainer container;

    public WSRPHttpServletRequest(HttpSession session) {
        this.session = session;
        this.parameters = new HashMap<String, String[]>();
        this.attributes = new HashMap<String, Object>();
        try {
            this.container = ExoContainerContext.getCurrentContainer();
            WSRPHttpServletRequest wsrpHttpServletRequest = (WSRPHttpServletRequest)this.container.getComponentInstanceOfType(WSRPHttpServletRequest.class);
            this.scheme = wsrpHttpServletRequest.getScheme();
            this.serverName = wsrpHttpServletRequest.getServerName();
            this.serverPort = wsrpHttpServletRequest.getServerPort();
            this.locale = wsrpHttpServletRequest.getLocale();
            this.locales = wsrpHttpServletRequest.getLocales();
            this.characterEncoding = wsrpHttpServletRequest.getCharacterEncoding();
            this.protocol = wsrpHttpServletRequest.getProtocol();
        }
        catch (Exception e) {
            System.out.println("Exception: WSRPHttpServletRequest e.getCause() = " + e.getCause());
        }
    }

    public WSRPHttpServletRequest(HttpServletRequest request) {
        this.scheme = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.locale = request.getLocale();
        this.locales = request.getLocales();
        this.characterEncoding = request.getCharacterEncoding();
        this.protocol = request.getProtocol();
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Enumeration getHeaders(String arg0) {
        return null;
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean arg0) {
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public Object getAttribute(String arg0) {
        return this.attributes.get(arg0);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String charenc) throws UnsupportedEncodingException {
        this.characterEncoding = charenc != null ? charenc : null;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String arg0) {
        if (this.parameters.get(arg0) == null) {
            return null;
        }
        return this.parameters.get(arg0)[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String arg0) {
        Set<String> keys = this.parameters.keySet();
        HashSet<String> values = new HashSet<String>();
        int i = 0;
        for (String key : keys) {
            String[] valuesArray;
            if (key.equals(arg0) && (valuesArray = this.parameters.get(key)) != null) {
                for (int j = 0; j < valuesArray.length; ++j) {
                    values.add(valuesArray[j]);
                }
            }
            ++i;
        }
        return (String[])values.toArray();
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerPort(int num) {
        this.serverPort = num;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String arg0, Object arg1) {
        this.attributes.put(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        this.attributes.remove(arg0);
    }

    public void setLocale(Locale loc) {
        this.locale = loc != null ? loc : new Locale("en");
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return new Locale("en");
    }

    public void setLocales(Enumeration<Locale> locs) {
        if (locs != null) {
            this.locales = locs;
        } else if (this.locales == null) {
            Vector<Locale> mygetLocales = new Vector<Locale>();
            mygetLocales.add(new Locale("en"));
            this.locales = Collections.enumeration(mygetLocales);
        }
    }

    public Enumeration<Locale> getLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        Vector<Locale> mygetLocales = new Vector<Locale>();
        mygetLocales.add(this.getLocale());
        return Collections.enumeration(mygetLocales);
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getLocalAddr() {
        return "local adress";
    }

    public String getLocalName() {
        return "Local name";
    }

    public int getRemotePort() {
        return 0;
    }

    public void setParameter(String key, String value) {
        String[] valueArray = new String[]{value};
        this.parameters.put(key, valueArray);
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }
}

