/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.ProcessesFilter;

public class WorkFlowDAO
extends GenericDAOJPAImpl<WorkFlowEntity, Long> {
    public List<WorkFlowEntity> findAllWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findEnabledWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findAllWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    private Query buildWorkflowQueryCriteria(ProcessesFilter processesFilter) {
        String q = processesFilter.getQuery();
        Boolean enabled = processesFilter.getEnabled();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(WorkFlowEntity.class);
        Root root = criteriaQuery.from(WorkFlowEntity.class);
        if (q != null) {
            ArrayList<Predicate> qPredicates = new ArrayList<Predicate>();
            qPredicates.add(criteriaBuilder.like((Expression)root.get("title"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("description"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("summary"), "%" + q + "%"));
            predicates.add(criteriaBuilder.or(qPredicates.toArray(new Predicate[0])));
        }
        if (enabled != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("enabled"), (Object)enabled)}));
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("id"))});
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        return query;
    }

    public List<WorkFlowEntity> findWorkFlows(ProcessesFilter processesFilter, int offset, int limit) {
        List resultList;
        Query query = this.buildWorkflowQueryCriteria(processesFilter);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findEnabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findDisabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findDisabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public WorkFlowEntity getWorkFlowByProjectId(long projectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.getWorkFlowByProjectId", WorkFlowEntity.class);
        query.setParameter("projectId", (Object)projectId);
        try {
            return (WorkFlowEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

