/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.provider;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.social.core.identity.model.Profile;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CreateRequestPlugin", template="war:/notification/templates/push/CreateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="CancelRequestPlugin", template="war:/notification/templates/push/CancelRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestCommentPlugin", template="war:/notification/templates/push/RequestCommentPlugin.gtmpl")})
public class PushTemplateProvider
extends TemplateProvider {
    public PushTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CreateRequestPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CancelRequestPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestCommentPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)PushTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String requester = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_CREATOR.getKey());
            String processTitle = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_PROCESS.getKey());
            if (pluginId.equals("RequestCommentPlugin")) {
                String requestTitle = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_TITLE.getKey());
                String commentAuthor = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT_AUTHOR.getKey());
                Profile userProfile = NotificationUtils.getUserProfile(commentAuthor);
                templateContext.put((Object)"REQUEST_TITLE", (Object)requestTitle);
                templateContext.put((Object)"REQUEST_COMMENT_AUTHOR", (Object)commentAuthor);
                templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            } else {
                Profile userProfile = NotificationUtils.getUserProfile(requester);
                templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            }
            templateContext.put((Object)"PROCESS_TITLE", (Object)processTitle);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

