/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.listener;

import org.exoplatform.analytics.model.StatisticData;
import org.exoplatform.analytics.utils.AnalyticsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.task.dto.ProjectDto;

public class RequestAnalyticsListener
extends Listener<Work, ProjectDto> {
    private ProcessesService processesService;
    private final String operation;

    public RequestAnalyticsListener(InitParams initParams, ProcessesService processesService) {
        this.operation = initParams.getValueParam("operation").getValue();
        this.processesService = processesService;
    }

    public void onEvent(Event<Work, ProjectDto> event) throws Exception {
        StatisticData statisticData = new StatisticData();
        Work work = (Work)event.getSource();
        ProjectDto project = (ProjectDto)event.getData();
        WorkFlow workFlow = this.processesService.getWorkFlowByProjectId(project.getId());
        long userId = work.getCreatorId();
        statisticData.setModule("processes");
        statisticData.setSubModule("request");
        statisticData.setOperation(this.operation);
        statisticData.setUserId(userId);
        statisticData.addParameter("processID", (Object)workFlow.getId());
        statisticData.addParameter("processName", (Object)workFlow.getTitle());
        statisticData.addParameter("requestID", (Object)work.getId());
        statisticData.addParameter("requestName", (Object)work.getTitle());
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }
}

