/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.storage;

import jakarta.persistence.EntityNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.processes.Utils.EntityMapper;
import org.exoplatform.processes.Utils.ProcessesUtils;
import org.exoplatform.processes.dao.WorkDraftDAO;
import org.exoplatform.processes.dao.WorkFlowDAO;
import org.exoplatform.processes.entity.WorkEntity;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.CreatorIdentityEntity;
import org.exoplatform.processes.model.IdentityEntity;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.ProfileEntity;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.model.WorkStatus;
import org.exoplatform.processes.rest.util.EntityBuilder;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.storage.ProcessesStorage;
import org.exoplatform.processes.storage.ProcessesStorageImpl;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.task.dao.TaskQuery;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.ProjectService;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.ProjectUtil;
import org.exoplatform.task.util.UserUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProcessesStorageImplTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<EntityMapper> ENTITY_MAPPER = Mockito.mockStatic(EntityMapper.class);
    private static final MockedStatic<UserUtil> USER_UTIL = Mockito.mockStatic(UserUtil.class);
    private static final MockedStatic<ProcessesUtils> PROCESSES_UTILS = Mockito.mockStatic(ProcessesUtils.class);
    private static final MockedStatic<ProjectUtil> PROJECT_UTIL = Mockito.mockStatic(ProjectUtil.class);
    @Mock
    private WorkFlowDAO workFlowDAO;
    @Mock
    private WorkDraftDAO workDraftDAO;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private TaskService taskService;
    @Mock
    private ProjectService projectService;
    @Mock
    private StatusService statusService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private MembershipHandler membershipHandler;
    private ListenerService listenerService;
    @Mock
    private ProcessesAttachmentService processesAttachmentService;
    @Mock
    private FileService fileService;
    @Mock
    private OrganizationService organizationService;
    private ProcessesStorage processesStorage;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        ENTITY_MAPPER.close();
        USER_UTIL.close();
        PROCESSES_UTILS.close();
        PROJECT_UTIL.close();
    }

    @Before
    public void setUp() throws Exception {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.listenerService = new ListenerService(new ExoContainerContext(null));
        this.listenerService = (ListenerService)Mockito.spy((Object)this.listenerService);
        this.processesStorage = new ProcessesStorageImpl(this.workFlowDAO, this.workDraftDAO, this.taskService, this.projectService, this.statusService, this.identityManager, this.spaceService, this.listenerService, this.processesAttachmentService, this.fileService, this.organizationService);
    }

    @Test
    public void deleteWorkflowById() throws org.exoplatform.task.exception.EntityNotFoundException {
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        ProjectDto projectDto = (ProjectDto)Mockito.mock(ProjectDto.class);
        ArrayList<WorkEntity> drafts = new ArrayList<WorkEntity>();
        drafts.add(new WorkEntity());
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.find((Serializable)Long.valueOf(1L)))).thenReturn(null);
        Throwable exception = Assert.assertThrows(EntityNotFoundException.class, () -> this.processesStorage.deleteWorkflowById(Long.valueOf(1L)));
        Assert.assertEquals((Object)"Workflow not found", (Object)exception.getMessage());
        ((ProjectService)Mockito.verify((Object)this.projectService, (VerificationMode)Mockito.times((int)0))).getProject(Long.valueOf(0L));
        ((WorkFlowDAO)Mockito.verify((Object)this.workFlowDAO, (VerificationMode)Mockito.times((int)0))).delete((Object)workFlowEntity);
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)workFlowEntity);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)projectDto);
        Mockito.when((Object)projectDto.getId()).thenReturn((Object)1L);
        Mockito.when((Object)workFlowEntity.getProjectId()).thenReturn((Object)1L);
        Mockito.when((Object)this.workDraftDAO.getDraftsByWorkflowId(1L)).thenReturn(drafts);
        this.processesStorage.deleteWorkflowById(Long.valueOf(1L));
        ((WorkDraftDAO)Mockito.verify((Object)this.workDraftDAO, (VerificationMode)Mockito.times((int)1))).deleteAll(drafts);
        ((ProjectService)Mockito.verify((Object)this.projectService, (VerificationMode)Mockito.times((int)1))).getProject(Long.valueOf(1L));
        ((WorkFlowDAO)Mockito.verify((Object)this.workFlowDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)workFlowEntity);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenThrow(new Throwable[]{new org.exoplatform.task.exception.EntityNotFoundException(1L, Object.class)});
        this.processesStorage.deleteWorkflowById(Long.valueOf(1L));
        Throwable exception2 = Assert.assertThrows(org.exoplatform.task.exception.EntityNotFoundException.class, () -> this.projectService.getProject(Long.valueOf(1L)));
        Assert.assertEquals((Object)"Object does not exist with ID: 1", (Object)exception2.getMessage());
    }

    @Test
    public void saveWorkflow() throws org.exoplatform.task.exception.EntityNotFoundException {
        IllustrativeAttachment illustrativeAttachment = new IllustrativeAttachment(null, "image.png", "image/png", Long.valueOf(1365L), Long.valueOf(new Date().getTime()));
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        attachments.add(attachment);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add("manager");
        memberships.add("participator");
        HashSet<String> managers = new HashSet<String>(Arrays.asList((String)memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
        ProjectDto projectDto = new ProjectDto();
        Space space = (Space)Mockito.mock(Space.class);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWorkFlow(null, 1L));
        Assert.assertEquals((Object)"workflow argument is null", (Object)exception1.getMessage());
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWorkFlow(workFlow, 1L));
        Assert.assertEquals((Object)"identity is not exist", (Object)exception2.getMessage());
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        Mockito.when((Object)workFlow.getId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getProjectId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getSpaceId()).thenReturn((Object)"1");
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(workFlow.getProjectId()))).thenReturn((Object)projectDto);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/spaces/processes_space");
        Mockito.when((Object)space.getId()).thenReturn((Object)"2");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/processes_space")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        USER_UTIL.when(() -> UserUtil.getSpaceMemberships((String)space.getGroupId())).thenReturn(memberships);
        workFlow.setDescription("anything");
        workFlow.setTitle("title");
        workFlow.setProjectId(1L);
        workFlow.setSpaceId("1");
        ArrayList<CreatorIdentityEntity> identityEntities = new ArrayList<CreatorIdentityEntity>();
        ProfileEntity profile = new ProfileEntity((String)(StringUtils.isNotEmpty((CharSequence)space.getAvatarUrl()) ? space.getAvatarUrl() : "/portal/rest/v1/social/spaces/" + space.getPrettyName() + "/avatar"), space.getDisplayName());
        IdentityEntity identityEntity = new IdentityEntity("", space.getPrettyName(), "space", profile);
        identityEntities.add(new CreatorIdentityEntity(identityEntity));
        profile = new ProfileEntity(null, "users");
        identityEntity = new IdentityEntity("group:users", "platform/users", "group", profile);
        identityEntities.add(new CreatorIdentityEntity(identityEntity));
        workFlow.setRequestsCreators(identityEntities);
        PROJECT_UTIL.when(() -> ProjectUtil.newProjectInstanceDto((String)workFlow.getTitle(), (String)workFlow.getDescription(), (Set)managers, (Set)participators)).thenReturn((Object)projectDto);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)workFlow.getProjectId())).thenReturn((Object)space);
        projectDto.setId(1L);
        Mockito.when((Object)this.projectService.createProject(projectDto)).thenReturn((Object)projectDto);
        ((StatusService)Mockito.doNothing().when((Object)this.statusService)).createInitialStatuses(projectDto);
        Mockito.when((Object)workFlow.getAttachments()).thenReturn((Object)attachments.toArray(new Attachment[attachments.size()]));
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        WorkFlowEntity newWorkFlowEntity = new WorkFlowEntity();
        newWorkFlowEntity.setId(Long.valueOf(1L));
        newWorkFlowEntity.setProjectId(Long.valueOf(1L));
        newWorkFlowEntity.hashCode();
        newWorkFlowEntity.toString();
        newWorkFlowEntity.equals((Object)workFlow);
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.create((Object)workFlowEntity))).thenReturn((Object)newWorkFlowEntity);
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.update((Object)workFlowEntity))).thenReturn((Object)newWorkFlowEntity);
        Mockito.when((Object)workFlow.getIllustrativeAttachment()).thenReturn((Object)illustrativeAttachment);
        this.processesStorage.saveWorkFlow(workFlow, 1L);
        ((WorkFlowDAO)Mockito.verify((Object)this.workFlowDAO, (VerificationMode)Mockito.times((int)1))).create((Object)workFlowEntity);
        PROCESSES_UTILS.verify(() -> ProcessesUtils.broadcast((ListenerService)this.listenerService, (String)"exo.process.created", (Object)1L, (Object)EntityMapper.fromEntity((WorkFlowEntity)workFlowEntity, (IllustrativeAttachment)illustrativeAttachment, (List)memberships)), Mockito.times((int)1));
        ((ProcessesAttachmentService)Mockito.verify((Object)this.processesAttachmentService, (VerificationMode)Mockito.times((int)1))).linkAttachmentsToEntity(attachments.toArray(new Attachment[0]), Long.valueOf(1L), Long.valueOf(1L), "workflow", Long.valueOf(1L));
        Mockito.when((Object)workFlow.getId()).thenReturn((Object)1L);
        this.processesStorage.saveWorkFlow(workFlow, 1L);
        ((WorkFlowDAO)Mockito.verify((Object)this.workFlowDAO, (VerificationMode)Mockito.times((int)1))).update((Object)workFlowEntity);
    }

    @Test
    public void countWorksByWorkflow() throws Exception {
        this.processesStorage.countWorksByWorkflow(1L, false);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).countTasks((TaskQuery)ArgumentMatchers.any());
        this.processesStorage.countWorksByWorkflow(1L, true);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).countTasks((TaskQuery)ArgumentMatchers.any());
    }

    @Test
    public void deleteWorkById() throws org.exoplatform.task.exception.EntityNotFoundException {
        TaskDto taskDto = (TaskDto)Mockito.mock(TaskDto.class);
        ProjectDto projectDto = (ProjectDto)Mockito.mock(ProjectDto.class);
        StatusDto statusDto = (StatusDto)Mockito.mock(StatusDto.class);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)taskDto);
        Mockito.when((Object)taskDto.getStatus()).thenReturn((Object)statusDto);
        Mockito.when((Object)statusDto.getProject()).thenReturn((Object)projectDto);
        this.processesStorage.deleteWorkById(Long.valueOf(1L));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).removeTask(1L);
        Mockito.when((Object)this.taskService.getTask(1L)).thenThrow(org.exoplatform.task.exception.EntityNotFoundException.class);
        this.processesStorage.deleteWorkById(Long.valueOf(1L));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).removeTask(1L);
    }

    @Test
    public void saveWork() throws org.exoplatform.task.exception.EntityNotFoundException, IllegalAccessException, ObjectNotFoundException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        attachments.add(attachment);
        Work work = new Work();
        ProjectDto projectDto = new ProjectDto();
        projectDto.setId(1L);
        StatusDto statusDto = (StatusDto)Mockito.mock(StatusDto.class);
        TaskDto taskDto = (TaskDto)Mockito.mock(TaskDto.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Profile profile = new Profile();
        profile.setProperty("fullName", (Object)"Root root");
        WorkEntity WorkEntity2 = (WorkEntity)Mockito.mock(WorkEntity.class);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)taskDto.getStatus()).thenReturn((Object)statusDto);
        Mockito.when((Object)statusDto.getProject()).thenReturn((Object)projectDto);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWork(null, 1L));
        Assert.assertEquals((Object)"work argument is null", (Object)exception1.getMessage());
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWork(work, 1L));
        Assert.assertEquals((Object)"identity is not exist", (Object)exception2.getMessage());
        work.setId(0L);
        work.setProjectId(1L);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(work.getProjectId()))).thenReturn((Object)projectDto);
        ENTITY_MAPPER.when(() -> EntityMapper.workToTask((Work)work)).thenReturn((Object)taskDto);
        ENTITY_MAPPER.when(() -> EntityMapper.taskToWork((TaskDto)taskDto)).thenReturn((Object)work);
        Mockito.when((Object)taskDto.getTitle()).thenReturn((Object)"");
        Mockito.when((Object)this.taskService.createTask(taskDto)).thenReturn((Object)taskDto);
        this.processesStorage.saveWork(work, 1L);
        PROCESSES_UTILS.verify(() -> ProcessesUtils.broadcast((ListenerService)this.listenerService, (String)"exo.process.request.created", (Object)work, (Object)projectDto), Mockito.times((int)1));
        work.setIsDraft(Boolean.valueOf(true));
        work.setId(0L);
        work.setDraftId(Long.valueOf(1L));
        WorkFlow workFlow = new WorkFlow();
        workFlow.setProjectId(1L);
        Mockito.when((Object)taskDto.getId()).thenReturn((Object)1L);
        Mockito.when((Object)((WorkEntity)this.workDraftDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)WorkEntity2);
        this.processesStorage.saveWork(work, 1L);
        ((ProcessesAttachmentService)Mockito.verify((Object)this.processesAttachmentService, (VerificationMode)Mockito.times((int)1))).moveAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(1L), "workdraft", Long.valueOf(1L), "task", Long.valueOf(1L));
        ((WorkDraftDAO)Mockito.verify((Object)this.workDraftDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)WorkEntity2);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(work.getProjectId()))).thenThrow(org.exoplatform.task.exception.EntityNotFoundException.class);
        work.setId(1L);
        Mockito.when((Object)this.taskService.getTask(work.getId())).thenReturn((Object)taskDto);
        TaskDto updatedTask = new TaskDto();
        updatedTask.setCompleted(true);
        StatusDto statusDto1 = new StatusDto();
        statusDto1.setName("Canceled");
        statusDto1.setProject(projectDto);
        updatedTask.setStatus(statusDto1);
        Mockito.when((Object)this.taskService.updateTask(taskDto)).thenReturn((Object)updatedTask);
        ArrayList<StatusDto> statuses = new ArrayList<StatusDto>();
        statuses.add(statusDto1);
        Mockito.when((Object)this.statusService.getStatuses(1L)).thenReturn(statuses);
        work.setStatus("Canceled");
        this.processesStorage.saveWork(work, 1L);
        PROCESSES_UTILS.verify(() -> ProcessesUtils.broadcast((ListenerService)this.listenerService, (String)"exo.process.request.canceled", (Object)updatedTask, (Object)updatedTask.getStatus().getProject()), Mockito.times((int)1));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).updateTask(taskDto);
        Mockito.when((Object)this.taskService.getTask(work.getId())).thenThrow(org.exoplatform.task.exception.EntityNotFoundException.class);
        Throwable exception3 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWork(work, 1L));
        Assert.assertEquals((Object)"Task not found", (Object)exception3.getMessage());
        work.setId(0L);
        Throwable exception4 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWork(work, 1L));
        Assert.assertEquals((Object)"Task's project not found", (Object)exception4.getMessage());
    }

    @Test
    public void saveWorkDraft() {
        Work work = new Work();
        work.setId(0L);
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(1L);
        workFlow.setProjectId(1L);
        WorkEntity workEntity = new WorkEntity();
        workEntity.setId(Long.valueOf(1L));
        workEntity.hashCode();
        workEntity.equals((Object)workEntity);
        workEntity.toString();
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.saveWorkDraft(work, 1L));
        Assert.assertEquals((Object)"identity is not exist", (Object)exception1.getMessage());
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((Work)work)).thenReturn((Object)workEntity);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        work.setWorkFlow(workFlow);
        Mockito.when((Object)((WorkEntity)this.workDraftDAO.create((Object)workEntity))).thenReturn((Object)workEntity);
        this.processesStorage.saveWorkDraft(work, 1L);
        ((ProcessesAttachmentService)Mockito.verify((Object)this.processesAttachmentService, (VerificationMode)Mockito.times((int)1))).copyAttachmentsToEntity(Long.valueOf(1L), Long.valueOf(work.getWorkFlow().getId()), "workflow", workEntity.getId(), "workdraft", Long.valueOf(1L));
        ((WorkDraftDAO)Mockito.verify((Object)this.workDraftDAO, (VerificationMode)Mockito.times((int)1))).create((Object)workEntity);
        work.setId(1L);
        this.processesStorage.saveWorkDraft(work, 1L);
        ((WorkDraftDAO)Mockito.verify((Object)this.workDraftDAO, (VerificationMode)Mockito.times((int)1))).update((Object)workEntity);
    }

    @Test
    public void deleteWorkDraftById() {
        WorkEntity WorkEntity2 = new WorkEntity();
        Mockito.when((Object)((WorkEntity)this.workDraftDAO.find((Serializable)Long.valueOf(1L)))).thenReturn(null);
        Throwable exception1 = Assert.assertThrows(EntityNotFoundException.class, () -> this.processesStorage.deleteWorkDraftById(1L));
        Assert.assertEquals((Object)"Work Draft not found", (Object)exception1.getMessage());
        Mockito.when((Object)((WorkEntity)this.workDraftDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)WorkEntity2);
        this.processesStorage.deleteWorkDraftById(1L);
        ((WorkDraftDAO)Mockito.verify((Object)this.workDraftDAO, (VerificationMode)Mockito.times((int)1))).delete((Object)WorkEntity2);
    }

    @Test
    public void getWorkById() throws Exception {
        TaskDto taskDto = (TaskDto)Mockito.mock(TaskDto.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        ArrayList<TaskDto> list = new ArrayList<TaskDto>();
        list.add(taskDto);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"root");
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesStorage.getWorkById(1L, 1L));
        Assert.assertEquals((Object)"identity is not exist", (Object)exception1.getMessage());
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)this.taskService.findTasks((TaskQuery)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(list);
        this.processesStorage.getWorkById(1L, 1L);
        EntityMapper.taskToWork((TaskDto)taskDto);
        Mockito.when((Object)this.taskService.findTasks((TaskQuery)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new org.exoplatform.task.exception.EntityNotFoundException(1L, Object.class)});
        Throwable exception2 = Assert.assertThrows(EntityNotFoundException.class, () -> this.processesStorage.getWorkById(1L, 1L));
        Assert.assertEquals((Object)"work not found", (Object)exception2.getMessage());
    }

    @Test
    public void updateWorkCompleted() throws org.exoplatform.task.exception.EntityNotFoundException {
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.organizationService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(SpaceService.class)).thenReturn((Object)this.spaceService);
        TaskDto taskDto = new TaskDto();
        StatusDto statusDto = new StatusDto();
        statusDto.setId(Long.valueOf(1L));
        ArrayList statusDtos = new ArrayList();
        ArrayList taskDtos = new ArrayList();
        statusDto.setProject(new ProjectDto());
        taskDto.setStatus(statusDto);
        taskDto.setId(1L);
        taskDto.setDescription("description");
        taskDto.setTitle("task");
        EntityMapper.toWorkStatuses(statusDtos);
        EntityMapper.tasksToWorkList(taskDtos);
        Work work = new Work();
        work.setId(1L);
        ArrayList<Work> works = new ArrayList<Work>();
        works.add(work);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        workFlowEntity.setId(Long.valueOf(1L));
        workFlowEntity.setCreatorId(Long.valueOf(1L));
        workFlowEntity.setModifierId(Long.valueOf(1L));
        workFlowEntity.setProjectId(Long.valueOf(22L));
        WorkFlow workFlow1 = new WorkFlow();
        workFlow1.setProjectId(1L);
        WorkFlow workFlow2 = new WorkFlow();
        workFlow2.setProjectId(2L);
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        workFlows.add(workFlow1);
        workFlows.add(workFlow2);
        WorkEntity workEntity = new WorkEntity();
        workEntity.setId(Long.valueOf(11L));
        workEntity.setCreatorId(Long.valueOf(1L));
        workEntity.setWorkFlow(workFlowEntity);
        workEntity.setIsDraft(Boolean.valueOf(true));
        workEntity.setWorkFlow(workFlowEntity);
        ArrayList<WorkEntity> workEntities = new ArrayList<WorkEntity>();
        workEntities.add(workEntity);
        EntityMapper.toEntity((Work)work);
        EntityMapper.toEntity((WorkFlow)workFlow2);
        List workFlowEntities2 = EntityMapper.fromWorkFlows(workFlows);
        Assert.assertNotNull((Object)workFlowEntities2);
        EntityMapper.workToTask((Work)work);
        EntityMapper.toWorkStatus((StatusDto)statusDto);
        EntityMapper.fromEntity((WorkEntity)workEntity);
        List works1 = EntityMapper.fromWorkEntities(workEntities);
        Assert.assertNotNull((Object)works1);
        Mockito.when((Object)this.taskService.getTask(1L)).thenReturn((Object)taskDto);
        this.processesStorage.updateWorkCompleted(Long.valueOf(1L), true);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).updateTask(taskDto);
        Mockito.when((Object)this.taskService.getTask(1L)).thenThrow(new Throwable[]{new org.exoplatform.task.exception.EntityNotFoundException(1L, Object.class)});
        Throwable exception2 = Assert.assertThrows(EntityNotFoundException.class, () -> this.processesStorage.updateWorkCompleted(Long.valueOf(1L), true));
        Assert.assertEquals((Object)"work not found", (Object)exception2.getMessage());
    }

    @Test
    public void getWorks() throws Exception {
        TaskQuery taskQuery = (TaskQuery)Mockito.mock(TaskQuery.class);
        WorkFilter workFilter = new WorkFilter();
        TaskDto taskDto = new TaskDto();
        taskDto.setTitle("task");
        taskDto.setId(11L);
        ArrayList<TaskDto> tasks = new ArrayList<TaskDto>();
        tasks.add(taskDto);
        Work work = new Work();
        ArrayList<Work> works = new ArrayList<Work>();
        List workEntities = EntityBuilder.toWorkEntityList(works);
        Assert.assertEquals((long)0L, (long)workEntities.size());
        works.add(work);
        workEntities = EntityBuilder.toWorkEntityList(works);
        Assert.assertEquals((long)1L, (long)workEntities.size());
        workFilter.setStatus("Request");
        workFilter.setQuery("test");
        workFilter.setCompleted(Boolean.valueOf(true));
        WorkFlow workFlow1 = new WorkFlow();
        workFlow1.setProjectId(1L);
        WorkFlow workFlow2 = new WorkFlow();
        workFlow2.setProjectId(2L);
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        workFlows.add(workFlow1);
        workFlows.add(workFlow2);
        ProjectDto projectDto = (ProjectDto)Mockito.mock(ProjectDto.class);
        projectDto.setId(1L);
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Mockito.when((Object)this.identityManager.getIdentity(String.valueOf(currentOwnerId))).thenReturn((Object)currentIdentity);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getUserNameByIdentityId((IdentityManager)((IdentityManager)ArgumentMatchers.any()), (long)ArgumentMatchers.anyLong())).thenCallRealMethod();
        String user = ProcessesUtils.getUserNameByIdentityId((IdentityManager)this.identityManager, (long)1L);
        Assert.assertNotNull((Object)user);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ProjectService.class)).thenReturn((Object)this.projectService);
        Mockito.when((Object)this.projectService.getProject(Long.valueOf(1L))).thenReturn((Object)projectDto);
        Space space = ProcessesUtils.getProjectParentSpace((Long)1L);
        Assert.assertNull((Object)space);
        Mockito.when((Object)this.processesStorage.findWorkFlows((ProcessesFilter)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(workFlows);
        Mockito.when((Object)this.taskService.findTasks(taskQuery, 0, 0)).thenReturn(tasks);
        ENTITY_MAPPER.when(() -> EntityMapper.tasksToWorkList((List)tasks)).thenReturn(works);
        this.processesStorage.getWorks(1L, workFilter, 0, 0);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)1))).findTasks((TaskQuery)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    @Test
    public void getAvailableWorkStatuses() {
        WorkFlow workFlow1 = new WorkFlow();
        workFlow1.setProjectId(1L);
        WorkFlow workFlow2 = new WorkFlow();
        workFlow2.setProjectId(2L);
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        workFlows.add(workFlow1);
        workFlows.add(workFlow2);
        StatusDto statusDto = (StatusDto)Mockito.mock(StatusDto.class);
        ArrayList<StatusDto> statuses = new ArrayList<StatusDto>();
        statuses.add(statusDto);
        WorkStatus workStatus = new WorkStatus();
        workStatus.setName("Request");
        workStatus.setId(Long.valueOf(1L));
        workStatus.setRank(Integer.valueOf(20));
        ArrayList<WorkStatus> workStatuses = new ArrayList<WorkStatus>();
        workStatuses.add(workStatus);
        Mockito.when((Object)this.statusService.getStatuses(1L)).thenReturn(statuses);
        Mockito.when((Object)this.processesStorage.findAllWorkFlows(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(workFlows);
        ENTITY_MAPPER.when(() -> EntityMapper.toWorkStatuses((List)statuses)).thenReturn(workStatuses);
        List workStatusList = this.processesStorage.getAvailableWorkStatuses();
        Assert.assertEquals((long)1L, (long)workStatusList.size());
    }

    @Test
    public void getIllustrationImageById() throws Exception {
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file", "image/png", "processesApp", 1253L, new Date(), null, "", false);
        FileItem fileItem = new FileItem(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getNameSpace(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.isDeleted(), null);
        IllustrativeAttachment illustrativeAttachment = this.processesStorage.getIllustrationImageById(null);
        Assert.assertNull((Object)illustrativeAttachment);
        Mockito.when((Object)this.fileService.getFile(1L)).thenReturn(null);
        Throwable exception = Assert.assertThrows(ObjectNotFoundException.class, () -> this.processesStorage.getIllustrationImageById(Long.valueOf(1L)));
        Assert.assertEquals((Object)"Illustration image not found", (Object)exception.getMessage());
        Mockito.when((Object)this.fileService.getFile(1L)).thenReturn((Object)fileItem);
        IllustrativeAttachment illustrativeAttachment1 = this.processesStorage.getIllustrationImageById(Long.valueOf(1L));
        Assert.assertNotNull((Object)illustrativeAttachment1);
    }

    @Test
    public void findWorkflow() throws Exception {
        IllustrativeAttachment illustrativeAttachment = new IllustrativeAttachment(null, "image.png", "image/png", Long.valueOf(1365L), Long.valueOf(new Date().getTime()));
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        attachments.add(attachment);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add("manager");
        memberships.add("participator");
        HashSet<String> managers = new HashSet<String>(Arrays.asList((String)memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
        ProjectDto projectDto = new ProjectDto();
        Space space = (Space)Mockito.mock(Space.class);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        Mockito.when((Object)workFlow.getId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getProjectId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getSpaceId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/spaces/processes_space");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/processes_space")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        USER_UTIL.when(() -> UserUtil.getSpaceMemberships((String)space.getGroupId())).thenReturn(memberships);
        workFlow.setDescription("anything");
        workFlow.setTitle("title");
        workFlow.setProjectId(1L);
        workFlow.setSpaceId("1");
        PROJECT_UTIL.when(() -> ProjectUtil.newProjectInstanceDto((String)workFlow.getTitle(), (String)workFlow.getDescription(), (Set)managers, (Set)participators)).thenReturn((Object)projectDto);
        projectDto.setId(1L);
        Mockito.when((Object)this.projectService.createProject(projectDto)).thenReturn((Object)projectDto);
        ((StatusService)Mockito.doNothing().when((Object)this.statusService)).createInitialStatuses(projectDto);
        Mockito.when((Object)workFlow.getAttachments()).thenReturn((Object)attachments.toArray(new Attachment[attachments.size()]));
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        WorkFlowEntity newWorkFlowEntity = new WorkFlowEntity();
        newWorkFlowEntity.setId(Long.valueOf(1L));
        newWorkFlowEntity.setProjectId(Long.valueOf(1L));
        newWorkFlowEntity.hashCode();
        newWorkFlowEntity.toString();
        newWorkFlowEntity.equals((Object)workFlow);
        WorkFlowEntity newWorkFlowEntity1 = new WorkFlowEntity();
        newWorkFlowEntity1.setId(Long.valueOf(1L));
        newWorkFlowEntity1.setProjectId(Long.valueOf(1L));
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.create((Object)workFlowEntity))).thenReturn((Object)newWorkFlowEntity);
        ProcessesFilter filter = new ProcessesFilter("", null, null);
        ArrayList<WorkFlowEntity> workFlowEntities = new ArrayList<WorkFlowEntity>();
        workFlowEntities.add(newWorkFlowEntity);
        memberships = new ArrayList();
        memberships.add(identity.getRemoteId());
        memberships.add("member:/platform/administrators");
        memberships.add("*:/platform/administrators");
        memberships.add("*:/platform/users");
        Mockito.when((Object)this.workFlowDAO.findWorkFlows(filter, memberships, 0, 0)).thenReturn(workFlowEntities);
        Mockito.when((Object)workFlow.getIllustrativeAttachment()).thenReturn((Object)illustrativeAttachment);
        this.processesStorage.saveWorkFlow(workFlow, 1L);
        Mockito.when((Object)this.organizationService.getMembershipHandler()).thenReturn((Object)this.membershipHandler);
        Assert.assertEquals(null, (Object)this.processesStorage.getWorkFlowById(1L));
        ArrayList<MembershipImpl> memberships_ = new ArrayList<MembershipImpl>();
        MembershipImpl membership = new MembershipImpl();
        membership.setMembershipType("member");
        membership.setUserName("user");
        membership.setGroupId("/platform/administrators");
        memberships_.add(membership);
        MembershipImpl admin = new MembershipImpl();
        admin.setMembershipType("*");
        admin.setUserName("user");
        admin.setGroupId("/platform/administrators");
        memberships_.add(admin);
        membership = new MembershipImpl();
        membership.setMembershipType("*");
        membership.setUserName("user");
        membership.setGroupId("/platform/users");
        memberships_.add(membership);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)workFlow.getProjectId())).thenReturn((Object)space);
        ENTITY_MAPPER.when(() -> EntityMapper.fromEntity((WorkFlowEntity)newWorkFlowEntity1, null)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.organizationService.getMembershipHandler().findMembershipsByUser(identity.getRemoteId())).thenReturn(memberships_);
        Assert.assertEquals((long)1L, (long)this.processesStorage.findWorkFlows(filter, Long.parseLong(identity.getId()), 0, 0).size());
        MembershipImpl adminProcesses = new MembershipImpl();
        adminProcesses.setMembershipType("*");
        adminProcesses.setUserName("user");
        adminProcesses.setGroupId("/platform/processes");
        memberships_.add(adminProcesses);
        PROCESSES_UTILS.when(() -> ProcessesUtils.getProjectParentSpace((Long)workFlow.getProjectId())).thenReturn((Object)space);
        ENTITY_MAPPER.when(() -> EntityMapper.fromEntity((WorkFlowEntity)newWorkFlowEntity1, null)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.organizationService.getMembershipHandler().findMembershipsByUser(identity.getRemoteId())).thenReturn(memberships_);
        Assert.assertEquals((long)0L, (long)this.processesStorage.findWorkFlows(filter, Long.parseLong(identity.getId()), 0, 0).size());
    }

    @Test
    public void countWorkflow() {
        IllustrativeAttachment illustrativeAttachment = new IllustrativeAttachment(null, "image.png", "image/png", Long.valueOf(1365L), Long.valueOf(new Date().getTime()));
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        attachment.setId("1");
        attachments.add(attachment);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add("manager");
        memberships.add("participator");
        HashSet<String> managers = new HashSet<String>(Arrays.asList((String)memberships.get(0)));
        HashSet<String> participators = new HashSet<String>(Arrays.asList((String)memberships.get(1)));
        ProjectDto projectDto = new ProjectDto();
        Space space = (Space)Mockito.mock(Space.class);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        Mockito.when((Object)workFlow.getId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getProjectId()).thenReturn((Object)0L);
        Mockito.when((Object)workFlow.getSpaceId()).thenReturn((Object)"1");
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)space.getGroupId()).thenReturn((Object)"/spaces/processes_space");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/processes_space")).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceById("1")).thenReturn((Object)space);
        USER_UTIL.when(() -> UserUtil.getSpaceMemberships((String)space.getGroupId())).thenReturn(memberships);
        workFlow.setDescription("anything");
        workFlow.setTitle("title");
        workFlow.setProjectId(1L);
        workFlow.setSpaceId("1");
        PROJECT_UTIL.when(() -> ProjectUtil.newProjectInstanceDto((String)workFlow.getTitle(), (String)workFlow.getDescription(), (Set)managers, (Set)participators)).thenReturn((Object)projectDto);
        projectDto.setId(1L);
        Mockito.when((Object)this.projectService.createProject(projectDto)).thenReturn((Object)projectDto);
        ((StatusService)Mockito.doNothing().when((Object)this.statusService)).createInitialStatuses(projectDto);
        Mockito.when((Object)workFlow.getAttachments()).thenReturn((Object)attachments.toArray(new Attachment[attachments.size()]));
        ENTITY_MAPPER.when(() -> EntityMapper.toEntity((WorkFlow)workFlow)).thenReturn((Object)workFlowEntity);
        WorkFlowEntity newWorkFlowEntity = new WorkFlowEntity();
        newWorkFlowEntity.setId(Long.valueOf(1L));
        newWorkFlowEntity.setProjectId(Long.valueOf(1L));
        newWorkFlowEntity.hashCode();
        newWorkFlowEntity.toString();
        newWorkFlowEntity.equals((Object)workFlow);
        Mockito.when((Object)((WorkFlowEntity)this.workFlowDAO.create((Object)workFlowEntity))).thenReturn((Object)newWorkFlowEntity);
        ProcessesFilter filter = new ProcessesFilter("", null, Boolean.valueOf(true));
        Mockito.when((Object)this.workFlowDAO.countWorkFlows(filter)).thenReturn((Object)1);
        Mockito.when((Object)workFlow.getIllustrativeAttachment()).thenReturn((Object)illustrativeAttachment);
        ArrayList<CreatorIdentityEntity> identityEntities = new ArrayList<CreatorIdentityEntity>();
        ProfileEntity profile = new ProfileEntity((String)(StringUtils.isNotEmpty((CharSequence)space.getAvatarUrl()) ? space.getAvatarUrl() : "/portal/rest/v1/social/spaces/" + space.getPrettyName() + "/avatar"), space.getDisplayName());
        IdentityEntity identityEntity = new IdentityEntity("", space.getPrettyName(), "space", profile);
        identityEntities.add(new CreatorIdentityEntity(identityEntity));
        profile = new ProfileEntity(null, "users");
        identityEntity = new IdentityEntity("group:users", "platform/users", "group", profile);
        identityEntities.add(new CreatorIdentityEntity(identityEntity));
        workFlow.setRequestsCreators(identityEntities);
        this.processesStorage.saveWorkFlow(workFlow, 1L);
        Assert.assertEquals((long)1L, (long)this.processesStorage.countWorkFlows(filter));
    }
}

