/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.plugin;

import java.util.ArrayList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.plugin.CancelRequestPlugin;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CancelRequestPluginTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<NotificationUtils> NOTIFICATION_UTILS = Mockito.mockStatic(NotificationUtils.class);
    @Mock
    private InitParams initParams;
    @Mock
    private ProcessesService processesService;
    private CancelRequestPlugin cancelRequestPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        EXO_CONTAINER_CONTEXT.close();
        NOTIFICATION_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.cancelRequestPlugin = new CancelRequestPlugin(this.initParams);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ProcessesService.class)).thenReturn((Object)this.processesService);
    }

    @Test
    public void makeNotification() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationArguments.REQUEST_CREATOR, (Object)"root");
        ctx.append(NotificationArguments.REQUEST_PROCESS, (Object)"processTitle");
        ctx.append(NotificationArguments.REQUEST_TITLE, (Object)"requestTitle");
        ctx.append(NotificationArguments.WORKFLOW_PROJECT_ID, (Object)"1");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add("user1");
        receivers.add("user2");
        ctx.append(NotificationArguments.PROCESS_URL, (Object)"http://exoplatfrom.com/dw/tasks/projectDetail/1");
        NOTIFICATION_UTILS.when(() -> NotificationUtils.getReceivers((long)1L, (String)"root", (boolean)true)).thenReturn(receivers);
        NotificationInfo notificationInfo = this.cancelRequestPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_CREATOR.getKey()));
        Assert.assertEquals((Object)"http://exoplatfrom.com/dw/tasks/projectDetail/1", (Object)notificationInfo.getValueOwnerParameter(NotificationArguments.PROCESS_URL.getKey()));
        Assert.assertEquals((Object)"processTitle", (Object)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_PROCESS.getKey()));
        Assert.assertEquals((Object)"requestTitle", (Object)notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_TITLE.getKey()));
        Assert.assertEquals((Object)"root", (Object)notificationInfo.getFrom());
        Assert.assertEquals(receivers, (Object)notificationInfo.getSendToUserIds());
    }
}

