/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.Utils;

import java.util.HashSet;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.processes.Utils.EntityMapper;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class EntityMapperTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private OrganizationService organizationService;
    @Mock
    private SpaceService spaceService;
    @Mock
    private Space testSpace;
    @Mock
    private Group contributorsGroup;
    @Mock
    private Group administratorsGroup;
    @Mock
    private GroupHandler groupHandler;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
    }

    @Test
    public void fromEntity() throws Exception {
        COMMONS_UTILS.when(() -> CommonsUtils.getService(OrganizationService.class)).thenReturn((Object)this.organizationService);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(SpaceService.class)).thenReturn((Object)this.spaceService);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("web-contributors")).thenReturn(null);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/platform/administrators")).thenReturn(null);
        Space testSpace = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/testSpace")).thenReturn((Object)testSpace);
        Mockito.when((Object)this.organizationService.getGroupHandler()).thenReturn((Object)this.groupHandler);
        Mockito.when((Object)this.groupHandler.findGroupById("web-contributors")).thenReturn(null);
        Group contributorsGroup = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)this.groupHandler.findGroupById("/platform/web-contributors")).thenReturn((Object)contributorsGroup);
        Group administratorsGroup = (Group)Mockito.mock(Group.class);
        Mockito.when((Object)this.groupHandler.findGroupById("/platform/administrators")).thenReturn((Object)administratorsGroup);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        workFlowEntity.setId(Long.valueOf(1L));
        workFlowEntity.setTitle("workFlow");
        workFlowEntity.setCreatorId(Long.valueOf(1L));
        workFlowEntity.setSummary("workFlow summary");
        workFlowEntity.setModifierId(Long.valueOf(1L));
        workFlowEntity.setTitle("workFlow");
        workFlowEntity.setEnabled(true);
        workFlowEntity.setDescription("test");
        workFlowEntity.setProjectId(Long.valueOf(1L));
        HashSet<String> managers = new HashSet<String>();
        managers.add("web-contributors");
        managers.add("/platform/administrators");
        managers.add("/spaces/testSpace");
        workFlowEntity.setManager(managers);
        WorkFlow workFlow = EntityMapper.fromEntity((WorkFlowEntity)workFlowEntity, null);
        Assert.assertEquals((long)workFlow.getManager().size(), (long)managers.size());
    }
}

