/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.rest;

import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.model.WorkStatus;
import org.exoplatform.processes.rest.ProcessesRest;
import org.exoplatform.processes.rest.model.WorkEntity;
import org.exoplatform.processes.rest.model.WorkFlowEntity;
import org.exoplatform.processes.rest.util.EntityBuilder;
import org.exoplatform.processes.rest.util.RestUtils;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.attachments.rest.model.AttachmentEntity;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProcessesRestTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<RestUtils> REST_UTILS = Mockito.mockStatic(RestUtils.class);
    private static final MockedStatic<EntityBuilder> ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
    private static final MockedStatic<org.exoplatform.services.attachments.utils.EntityBuilder> ATTACHMENT_ENTITY_BUILDER = Mockito.mockStatic(org.exoplatform.services.attachments.utils.EntityBuilder.class);
    private static final MockedStatic<ConversationState> CONVERSATION_STATE = Mockito.mockStatic(ConversationState.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ProcessesService processesService;
    @Mock
    private ProcessesAttachmentService processesAttachmentService;
    @Mock
    private IdentityRegistry identityRegistry;
    private ProcessesRest processesRest;
    @Mock
    private Identity identity;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        REST_UTILS.close();
        ENTITY_BUILDER.close();
        ATTACHMENT_ENTITY_BUILDER.close();
        CONVERSATION_STATE.close();
    }

    @Before
    public void setUp() {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.processesRest = new ProcessesRest(this.processesService, this.identityManager, this.identityRegistry, this.processesAttachmentService);
        ConversationState conversationState = (ConversationState)Mockito.mock(ConversationState.class);
        CONVERSATION_STATE.when(() -> ConversationState.getCurrent()).thenReturn((Object)conversationState);
        CONVERSATION_STATE.when(() -> ConversationState.getCurrent().getIdentity()).thenReturn((Object)this.identity);
    }

    @Test
    public void getWorkFlows() throws Exception {
        ArrayList<WorkFlow> workFlows = new ArrayList<WorkFlow>();
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(1L);
        workFlow.setProjectId(1L);
        workFlows.add(workFlow);
        ArrayList workFlowEntities = new ArrayList();
        ProcessesFilter processesFilter = new ProcessesFilter();
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response1 = this.processesRest.getWorkFlows(Long.valueOf(1L), null, null, null, null, 0, 10);
        Assert.assertEquals((long)response1.getStatus(), (long)Response.Status.UNAUTHORIZED.getStatusCode());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.getWorkFlows(processesFilter, 0, 10, 1L)).thenReturn(workFlows);
        ENTITY_BUILDER.when(() -> EntityBuilder.toRestEntities((List)workFlows, null)).thenReturn(workFlowEntities);
        Response response2 = this.processesRest.getWorkFlows(Long.valueOf(1L), Boolean.valueOf(true), null, "test", null, 0, 10);
        Assert.assertEquals((long)response2.getStatus(), (long)Response.Status.OK.getStatusCode());
        Mockito.when((Object)this.processesService.getWorkFlows((ProcessesFilter)ArgumentMatchers.any(ProcessesFilter.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong())).thenThrow(RuntimeException.class);
        Response response3 = this.processesRest.getWorkFlows(Long.valueOf(1L), null, null, null, null, 0, 10);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void isProcessesManager() {
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response1 = this.processesRest.isProcessesManager();
        Assert.assertEquals((long)response1.getStatus(), (long)Response.Status.UNAUTHORIZED.getStatusCode());
        REST_UTILS.when(() -> RestUtils.isProcessesGroupMember((Identity)this.identity)).thenReturn((Object)true);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response2 = this.processesRest.isProcessesManager();
        Assert.assertEquals((long)response2.getStatus(), (long)Response.Status.OK.getStatusCode());
        Assert.assertEquals((Object)"true", (Object)response2.getEntity());
        REST_UTILS.when(() -> RestUtils.isProcessesGroupMember((Identity)this.identity)).thenThrow(RuntimeException.class);
        Response response3 = this.processesRest.isProcessesManager();
        Assert.assertEquals((long)response3.getStatus(), (long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    @Test
    public void deleteWorkflow() {
        Response response = this.processesRest.deleteWorkflow(null);
        Assert.assertEquals((long)response.getStatus(), (long)Response.Status.BAD_REQUEST.getStatusCode());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response1 = this.processesRest.deleteWorkflow(Long.valueOf(1L));
        Assert.assertEquals((long)response1.getStatus(), (long)Response.Status.UNAUTHORIZED.getStatusCode());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        REST_UTILS.when(() -> RestUtils.isProcessesGroupMember((Identity)this.identity)).thenReturn((Object)false);
        Response response2 = this.processesRest.deleteWorkflow(Long.valueOf(1L));
        Assert.assertEquals((long)response2.getStatus(), (long)Response.Status.UNAUTHORIZED.getStatusCode());
        REST_UTILS.when(() -> RestUtils.isProcessesGroupMember((Identity)this.identity)).thenReturn((Object)true);
        ((ProcessesService)Mockito.doNothing().when((Object)this.processesService)).deleteWorkflowById(Long.valueOf(1L));
        Response response3 = this.processesRest.deleteWorkflow(Long.valueOf(1L));
        Assert.assertEquals((long)response3.getStatus(), (long)Response.Status.OK.getStatusCode());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new EntityNotFoundException()}).when((Object)this.processesService)).deleteWorkflowById(Long.valueOf(1L));
        Response response4 = this.processesRest.deleteWorkflow(Long.valueOf(1L));
        Assert.assertEquals((long)response4.getStatus(), (long)Response.Status.NOT_FOUND.getStatusCode());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).deleteWorkflowById(Long.valueOf(1L));
        Response response5 = this.processesRest.deleteWorkflow(Long.valueOf(1L));
        Assert.assertEquals((long)response5.getStatus(), (long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    @Test
    public void updateWorkflow() throws ObjectNotFoundException, IllegalAccessException {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        Response response1 = this.processesRest.updateWorkFlow(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response2 = this.processesRest.updateWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.updateWorkFlow(workFlow, 1L)).thenReturn((Object)workFlow);
        Response response3 = this.processesRest.updateWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        Mockito.when((Object)this.processesService.updateWorkFlow(workFlow, 1L)).thenThrow(ObjectNotFoundException.class);
        Response response4 = this.processesRest.updateWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void shouldReturnUnauthorizedErrorWhenUpdateWorkflow() throws ObjectNotFoundException, IllegalAccessException {
        WorkFlow workFlow = new WorkFlow();
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        Date createdDate = new Date();
        Date modifiedDate = new Date();
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.updateWorkFlow(workFlow, 1L)).thenThrow(IllegalAccessException.class);
        Response response = this.processesRest.updateWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        WorkFlowEntity workFlowEntity1 = new WorkFlowEntity();
        workFlowEntity1.setId(1L);
        workFlowEntity1.setTitle("workFlow");
        workFlowEntity1.setCreatorId(1L);
        workFlowEntity1.setSummary("workFlow summary");
        workFlowEntity1.setModifierId(1L);
        workFlowEntity1.setTitle("workFlow");
        workFlowEntity1.setTitle("workFlow");
        workFlowEntity1.setEnabled(true);
        workFlowEntity1.setDescription("test");
        workFlowEntity1.hashCode();
        workFlowEntity1.equals((Object)workFlowEntity1);
        workFlowEntity1.toString();
        Response response1 = this.processesRest.updateWorkFlow(workFlowEntity1);
        WorkFlowEntity workFlowEntity2 = new WorkFlowEntity(1L, "title", "description", "summary", "image", "helpLink", true, 1L, createdDate, 1L, modifiedDate, 1L, null, null, null, null, false, null, null);
    }

    @Test
    public void shouldReturnServerErrorWhenUpdateWorkflow() throws Exception {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.updateWorkFlow(workFlow, 1L)).thenThrow(RuntimeException.class);
        Response response = this.processesRest.updateWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void createWorkflow() throws IllegalAccessException {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        Response response1 = this.processesRest.createWorkFlow(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response2 = this.processesRest.createWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity)).thenReturn((Object)workFlow);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.createWorkFlow(workFlow, 1L)).thenReturn((Object)workFlow);
        Response response3 = this.processesRest.createWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        Mockito.when((Object)this.processesService.createWorkFlow(workFlow, 1L)).thenThrow(IllegalAccessException.class);
        Response response4 = this.processesRest.createWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void shouldReturnServerErrorWhenCreateWorkflow() throws Exception {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkFlowEntity)workFlowEntity)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.createWorkFlow(workFlow, 1L)).thenThrow(RuntimeException.class);
        Response response = this.processesRest.createWorkFlow(workFlowEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getWorks() throws Exception {
        ArrayList works = new ArrayList();
        WorkFilter workFilter = new WorkFilter();
        workFilter.setStatus("ToDo");
        workFilter.setQuery("test");
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response1 = this.processesRest.getWorks(Long.valueOf(0L), "", Boolean.valueOf(false), "ToDo", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.getWorks(1L, workFilter, 0, 10)).thenReturn(works);
        Response response2 = this.processesRest.getWorks(null, "", Boolean.valueOf(false), "ToDo", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        workFilter.setCompleted(Boolean.valueOf(true));
        Mockito.when((Object)this.processesService.getWorks(1L, workFilter, 0, 10)).thenThrow(RuntimeException.class);
        Response response3 = this.processesRest.getWorks(Long.valueOf(1L), "", Boolean.valueOf(true), "ToDo", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void createWork() throws IllegalAccessException {
        WorkEntity workEntity = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        Response response1 = this.processesRest.createWork(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        workEntity.setProjectId(0L);
        workFlowEntity.setProjectId(0L);
        workEntity.setWorkFlow(workFlowEntity);
        workEntity.hashCode();
        workEntity.equals((Object)workEntity);
        workEntity.toString();
        Response response2 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response2.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        workEntity.setProjectId(1L);
        workEntity.getWorkFlow().setProjectId(1L);
        workEntity.getWorkFlow().setEnabled(false);
        workEntity.setCompleted(true);
        Response response6 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response6.getStatus());
        workEntity.getWorkFlow().setEnabled(true);
        Response response3 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response3.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity)).thenReturn((Object)work);
        Mockito.when((Object)this.processesService.createWork(work, 1L)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"")).thenReturn((Object)workEntity);
        Response response4 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response4.getStatus());
        Mockito.when((Object)this.processesService.createWork(work, 1L)).thenThrow(IllegalAccessException.class);
        Response response5 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response5.getStatus());
    }

    @Test
    public void shouldReturnServerErrorWhenCreateWork() throws Exception {
        WorkEntity workEntity = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        WorkFlowEntity workFlowEntity = new WorkFlowEntity();
        workFlowEntity.setCanShowPending(true);
        workFlowEntity.setParentSpace(null);
        workEntity.setWorkFlow(workFlowEntity);
        workEntity.setProjectId(1L);
        workEntity.getWorkFlow().setProjectId(1L);
        workEntity.getWorkFlow().setEnabled(true);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"")).thenReturn((Object)workEntity);
        Mockito.when((Object)this.processesService.createWork(work, 1L)).thenThrow(RuntimeException.class);
        Response response5 = this.processesRest.createWork(workEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response5.getStatus());
    }

    @Test
    public void updateWork() throws ObjectNotFoundException, IllegalAccessException {
        WorkEntity workEntity = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        Response response1 = this.processesRest.updateWork(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response3 = this.processesRest.updateWork(workEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response3.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity)).thenReturn((Object)work);
        Mockito.when((Object)this.processesService.updateWork(work, 1L)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"")).thenReturn((Object)workEntity);
        Response response4 = this.processesRest.updateWork(workEntity);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response4.getStatus());
        Mockito.when((Object)this.processesService.updateWork(work, 1L)).thenThrow(ObjectNotFoundException.class);
        Response response5 = this.processesRest.updateWork(workEntity);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response5.getStatus());
    }

    @Test
    public void shouldReturnUnauthorizedErrorWWhenUpdateWork() throws Exception {
        WorkEntity workEntity = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"")).thenReturn((Object)workEntity);
        Mockito.when((Object)this.processesService.updateWork(work, 1L)).thenThrow(IllegalAccessException.class);
        Response response6 = this.processesRest.updateWork(workEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response6.getStatus());
    }

    @Test
    public void shouldReturnServerErrorWhenUpdateWork() throws Exception {
        WorkEntity workEntity = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWork((ProcessesService)this.processesService, (WorkEntity)workEntity)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"")).thenReturn((Object)workEntity);
        Mockito.when((Object)this.processesService.updateWork(work, 1L)).thenThrow(RuntimeException.class);
        Response response6 = this.processesRest.updateWork(workEntity);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response6.getStatus());
    }

    @Test
    public void countWorksByWorkflow() throws Exception {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.countWorksByWorkflow(null, null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.countWorksByWorkflow(null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlowByProjectId(1L)).thenReturn(null);
        Response response2 = this.processesRest.countWorksByWorkflow(Long.valueOf(1L), null);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlowByProjectId(1L)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.countWorksByWorkflow(Long.valueOf(1L), Boolean.valueOf(false))).thenReturn((Object)2);
        Response response3 = this.processesRest.countWorksByWorkflow(Long.valueOf(1L), Boolean.valueOf(false));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        Mockito.when((Object)this.processesService.countWorksByWorkflow(Long.valueOf(1L), Boolean.valueOf(false))).thenThrow(RuntimeException.class);
        Response response4 = this.processesRest.countWorksByWorkflow(Long.valueOf(1L), Boolean.valueOf(false));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void deleteWorkById() {
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.deleteWork(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.deleteWork(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.processesRest.deleteWork(Long.valueOf(1L));
        ((ProcessesService)Mockito.verify((Object)this.processesService, (VerificationMode)Mockito.times((int)1))).deleteWorkById(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).deleteWorkById(Long.valueOf(1L));
        Response response3 = this.processesRest.deleteWork(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void createWorkDraft() {
        WorkEntity WorkEntity2 = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkEntity)WorkEntity2)).thenReturn((Object)work);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.createWorkDraft(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Response response1 = this.processesRest.createWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.createWorkDraft(work, 1L)).thenReturn((Object)work);
        Response response2 = this.processesRest.createWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).createWorkDraft(work, 1L);
        Response response3 = this.processesRest.createWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void getWorkDrafts() {
        ArrayList works = new ArrayList();
        WorkFilter workFilter = new WorkFilter();
        workFilter.setIsDraft(Boolean.valueOf(true));
        workFilter.setQuery("test");
        ArrayList WorkEntityList = new ArrayList();
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.getWorkDrafts(Long.valueOf(0L), "", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.getWorkDrafts(1L, workFilter, 0, 10)).thenReturn(works);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntityList((List)works)).thenReturn(WorkEntityList);
        Response response1 = this.processesRest.getWorkDrafts(null, "", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).getWorkDrafts(1L, workFilter, 0, 10);
        Response response2 = this.processesRest.getWorkDrafts(Long.valueOf(1L), "", "test", 0, 10);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void updateWorkDraft() throws ObjectNotFoundException {
        WorkEntity WorkEntity2 = new WorkEntity();
        Work work = (Work)Mockito.mock(Work.class);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkEntity)WorkEntity2)).thenReturn((Object)work);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.updateWorkDraft(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Response response1 = this.processesRest.updateWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ENTITY_BUILDER.when(() -> EntityBuilder.fromEntity((WorkEntity)WorkEntity2)).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toEntity((Work)work)).thenReturn((Object)WorkEntity2);
        Mockito.when((Object)this.processesService.updateWorkDraft(work, 1L)).thenReturn((Object)work);
        Response response2 = this.processesRest.updateWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("oldWorkDraft is not exist")}).when((Object)this.processesService)).updateWorkDraft(work, 1L);
        Response response4 = this.processesRest.updateWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response4.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).updateWorkDraft(work, 1L);
        Response response3 = this.processesRest.updateWorkDraft(WorkEntity2);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response3.getStatus());
    }

    @Test
    public void deleteWorkDraft() {
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.deleteWorkDraft(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Response response1 = this.processesRest.deleteWorkDraft(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response1.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response2 = this.processesRest.deleteWorkDraft(Long.valueOf(1L));
        ((ProcessesService)Mockito.verify((Object)this.processesService, (VerificationMode)Mockito.times((int)1))).deleteWorkDraftById(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new EntityNotFoundException()}).when((Object)this.processesService)).deleteWorkDraftById(Long.valueOf(1L));
        Response response3 = this.processesRest.deleteWorkDraft(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response3.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).deleteWorkDraftById(Long.valueOf(1L));
        Response response4 = this.processesRest.deleteWorkDraft(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void getWorkById() {
        Work work = (Work)Mockito.mock(Work.class);
        WorkEntity workEntity = (WorkEntity)Mockito.mock(WorkEntity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.getWorkById(null, "");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.getWorkById(null, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.processesService.getWorkById(1L, Long.valueOf(1L))).thenReturn((Object)work);
        ENTITY_BUILDER.when(() -> EntityBuilder.toWorkEntity((ProcessesService)this.processesService, (Work)work, (String)"workFlow")).thenReturn((Object)workEntity);
        Response response2 = this.processesRest.getWorkById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new EntityNotFoundException()}).when((Object)this.processesService)).getWorkById(1L, Long.valueOf(1L));
        Response response3 = this.processesRest.getWorkById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response3.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).getWorkById(1L, Long.valueOf(1L));
        Response response4 = this.processesRest.getWorkById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void getWorkflowById() throws IllegalAccessException {
        WorkFlow workFlow = (WorkFlow)Mockito.mock(WorkFlow.class);
        WorkFlowEntity workFlowEntity = (WorkFlowEntity)Mockito.mock(WorkFlowEntity.class);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.getWorkFlowById(null, "");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.getWorkFlowById(null, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlow(1L)).thenReturn(null);
        Response response2 = this.processesRest.getWorkFlowById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlow(1L)).thenReturn((Object)workFlow);
        ENTITY_BUILDER.when(() -> EntityBuilder.toEntity((WorkFlow)workFlow, (String)"")).thenReturn((Object)workFlowEntity);
        Response response3 = this.processesRest.getWorkFlowById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).getWorkFlow(1L);
        Response response4 = this.processesRest.getWorkFlowById(Long.valueOf(1L), "");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void createNewFormDocument() throws Exception {
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Attachment attachment = (Attachment)Mockito.mock(Attachment.class);
        AttachmentEntity attachmentEntity = (AttachmentEntity)Mockito.mock(AttachmentEntity.class);
        Response response = this.processesRest.createNewFormDocument(null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.createNewFormDocument(null, "any", "any", "any", null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.processesRest.createNewFormDocument("any", null, "any", "any", null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.processesRest.createNewFormDocument("any", "any", null, "any", null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response3.getStatus());
        Response response4 = this.processesRest.createNewFormDocument("any", "any", "any", null, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response4.getStatus());
        ATTACHMENT_ENTITY_BUILDER.when(() -> org.exoplatform.services.attachments.utils.EntityBuilder.fromAttachment((IdentityManager)this.identityManager, (Attachment)attachment)).thenReturn((Object)attachmentEntity);
        Response response7 = this.processesRest.createNewFormDocument("any", "any", "any", "any", "workflow", Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response7.getStatus());
        ((ProcessesAttachmentService)Mockito.doThrow((Throwable[])new Throwable[]{new ItemExistsException()}).when((Object)this.processesAttachmentService)).createNewFormDocument(Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
        Response response5 = this.processesRest.createNewFormDocument("any", "any", "any", "any", "workflow", Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response5.getStatus());
        ((ProcessesAttachmentService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesAttachmentService)).createNewFormDocument(Long.valueOf(ArgumentMatchers.anyLong()), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Long.valueOf(ArgumentMatchers.anyLong()));
        Response response6 = this.processesRest.createNewFormDocument("any", "any", "any", "any", "workflow", Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response6.getStatus());
    }

    @Test
    public void updateWorkCompleted() {
        HashMap<String, Boolean> completed = new HashMap<String, Boolean>();
        completed.put("value", null);
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.updateWorkCompleted(null, null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Response response1 = this.processesRest.updateWorkCompleted(null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response7 = this.processesRest.updateWorkCompleted(null, Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response7.getStatus());
        Response response2 = this.processesRest.updateWorkCompleted(completed, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.processesRest.updateWorkCompleted(completed, Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response3.getStatus());
        completed.put("value", true);
        Response response5 = this.processesRest.updateWorkCompleted(completed, Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response5.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new EntityNotFoundException()}).when((Object)this.processesService)).updateWorkCompleted(Long.valueOf(1L), true);
        Response response4 = this.processesRest.updateWorkCompleted(completed, Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response4.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).updateWorkCompleted(Long.valueOf(1L), true);
        Response response6 = this.processesRest.updateWorkCompleted(completed, Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response6.getStatus());
    }

    @Test
    public void getAvailableWorkStatuses() {
        ArrayList<WorkStatus> statuses = new ArrayList<WorkStatus>();
        statuses.add(new WorkStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        Response response = this.processesRest.getAvailableWorkStatuses();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        REST_UTILS.when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.processesService.getAvailableWorkStatuses()).thenReturn(statuses);
        Response response1 = this.processesRest.getAvailableWorkStatuses();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).getAvailableWorkStatuses();
        Response response2 = this.processesRest.getAvailableWorkStatuses();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void getImageIllustration() throws Exception {
        Request request = (Request)Mockito.mock(Request.class);
        IllustrativeAttachment illustrativeAttachment = new IllustrativeAttachment(Long.valueOf(1L), "file.png", null, "image/png", Long.valueOf(12654L), Long.valueOf(1234577L));
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(1L);
        workFlow.setIllustrativeAttachment(illustrativeAttachment);
        Response response = this.processesRest.getImageIllustration(request, null, 0L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlow(1L)).thenReturn(null);
        Response response1 = this.processesRest.getImageIllustration(request, Long.valueOf(1L), 0L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.processesService.getWorkFlow(1L)).thenReturn((Object)workFlow);
        Mockito.when((Object)this.processesService.getIllustrationImageById(Long.valueOf(1L))).thenReturn((Object)illustrativeAttachment);
        Mockito.when((Object)request.evaluatePreconditions((EntityTag)ArgumentMatchers.any(EntityTag.class))).thenReturn(null);
        Response response2 = this.processesRest.getImageIllustration(request, Long.valueOf(1L), 0L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.processesRest.getImageIllustration(request, Long.valueOf(1L), 133584L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Illustration image not found")}).when((Object)this.processesService)).getIllustrationImageById(Long.valueOf(1L));
        Response response4 = this.processesRest.getImageIllustration(request, Long.valueOf(1L), 133584L);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response4.getStatus());
        ((ProcessesService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.processesService)).getIllustrationImageById(Long.valueOf(1L));
        Response response5 = this.processesRest.getImageIllustration(request, Long.valueOf(1L), 133584L);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response5.getStatus());
    }
}

