/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.exoplatform;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertTrue;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

/**
 *
 */
public class SecureAssert
{

   /**
    * Check from it's own name if file exists.
    * 
    * @param fileName
    *           - name of the file
    */
   public static void assertFileExists(final String fileName)
   {
      AccessController.doPrivileged(new PrivilegedAction<Void>()
      {

         @Override
         public Void run()
         {
            assertTrue(new File(fileName).exists());
            return null;
         }

      });
   }

   /**
    * Check from it's own name if fileName is file.
    * 
    * @param fileName
    *           - name of the file
    */
   public static void assertIsFile(final String fileName)
   {
      AccessController.doPrivileged(new PrivilegedAction<Void>()
      {

         @Override
         public Void run()
         {
            assertTrue(new File(fileName).isFile());
            return null;
         }

      });
   }

   /**
    * Check from it's own name if file is not empty.
    * 
    * @param fileName
    *           - name of the file
    */
   public static void assertFileNotEmpty(final String fileName)
   {
      AccessController.doPrivileged(new PrivilegedAction<Void>()
      {

         @Override
         public Void run()
         {
            assertTrue(new File(fileName).length() > 0);
            return null;
         }

      });
   }

   /**
    * 
    * Check from it's own name if file is empty.
    * 
    * @param fileName
    *           - name of the file.
    */
   public static void assertFileEmpty(final String fileName)
   {
      AccessController.doPrivileged(new PrivilegedAction<Void>()
      {

         @Override
         public Void run()
         {
            assertEquals(new File(fileName).length(), 0);
            return null;
         }

      });
   }
}
