/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.api.auth.AccessDeniedException;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.IdentityService;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.core.model.RestIdentityImpl;
import org.exoplatform.social.client.core.service.ActivityServiceImpl;
import org.exoplatform.social.client.core.service.ServiceBase;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityServiceImpl
extends ServiceBase<RestIdentity, IdentityService<RestIdentity>>
implements IdentityService<RestIdentity> {
    private static final String BASE_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true);

    @Override
    public RestIdentity create(RestIdentity newInstance) throws AccessDeniedException, ServiceException {
        return null;
    }

    @Override
    public RestIdentity get(String uuid) throws AccessDeniedException, ServiceException {
        String targetURL = BASE_URL + "identity/" + uuid + ".json";
        HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.BASIC_AUTH);
        try {
            return SocialJSONDecodingSupport.parser(RestIdentityImpl.class, response);
        }
        catch (IOException ioex) {
            throw new ServiceException(IdentityServiceImpl.class, "IOException when reads Json Content.", ioex);
        }
        catch (ParseException pex) {
            throw new ServiceException(IdentityServiceImpl.class, "ParseException when reads Json Content.", pex);
        }
    }

    @Override
    public RestIdentity update(RestIdentity existingInstance) throws AccessDeniedException, ServiceException {
        return null;
    }

    @Override
    public RestIdentity delete(RestIdentity existingInstance) throws AccessDeniedException, ServiceException {
        return null;
    }

    @Override
    public String getIdentityId(String provider, String remoteId) throws ServiceException {
        String targetURL = "/" + SocialClientContext.getRestContextName() + "/" + SocialClientContext.getPortalContainerName() + "/social/identity/" + remoteId + "/id/show.json";
        HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.NO_AUTH);
        try {
            String content = SocialHttpClientSupport.getContent(response);
            Map map = SocialJSONDecodingSupport.parser(content);
            return (String)map.get("id");
        }
        catch (Exception ex) {
            throw new ServiceException(ActivityServiceImpl.class, "Exception when reads Json Content.", ex);
        }
    }
}

