/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.util;

import org.exoplatform.social.client.api.event.PropertyChangeEvent;
import org.exoplatform.social.client.api.event.PropertyChangeListener;
import org.exoplatform.social.client.api.model.Model;

public final class PropertyChangeSupport {
    private Model source = null;
    private PropertyChangeListener[] listeners = new PropertyChangeListener[0];
    private final Object listenersLock = new Object();

    public PropertyChangeSupport(Model source) {
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            PropertyChangeListener[] results = new PropertyChangeListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, results, 0, this.listeners.length);
            results[this.listeners.length] = listener;
            this.listeners = results;
        }
    }

    public void propertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        PropertyChangeListener[] interested = this.listeners;
        for (int i = 0; i < interested.length; ++i) {
            interested[i].propertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(PropertyChangeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != listener) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            PropertyChangeListener[] results = new PropertyChangeListener[this.listeners.length - 1];
            int j = 0;
            for (int i = 0; i < this.listeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.listeners[i];
            }
            this.listeners = results;
        }
    }

    public PropertyChangeListener[] findPropertyChangeListeners() {
        return this.listeners;
    }
}

