/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.api.model.Model;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.core.net.SocialHttpClientImpl;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;
import org.json.simple.parser.ParseException;

public class SocialHttpClientSupport {
    public static HttpResponse executeGet(String targetURL, SocialHttpClient.POLICY authPolicy, HttpParams params) throws SocialHttpClientException {
        SocialHttpClient httpClient = SocialHttpClientImpl.newInstance();
        if (SocialHttpClient.POLICY.BASIC_AUTH == authPolicy) {
            httpClient.setBasicAuthenticateToRequest();
        }
        HttpGet httpGet = new HttpGet(targetURL);
        BasicHeader header = new BasicHeader("Content-Type", "application/json");
        httpGet.setHeader((Header)header);
        HttpHost targetHost = new HttpHost(SocialClientContext.getHost(), SocialClientContext.getPort(), SocialClientContext.getProtocol());
        if (params != null) {
            httpGet.setParams(params);
        }
        try {
            HttpResponse response = httpClient.execute(targetHost, (HttpRequest)httpGet);
            SocialHttpClientSupport.handleError(response);
            if (SocialClientContext.isDeveloping()) {
                SocialHttpClientSupport.dumpHttpResponsetHeader(response);
                SocialHttpClientSupport.dumpContent(response);
            }
            return response;
        }
        catch (ClientProtocolException cpex) {
            throw new SocialHttpClientException(cpex.toString(), cpex);
        }
        catch (IOException ioex) {
            throw new SocialHttpClientException(ioex.toString(), ioex);
        }
    }

    public static HttpResponse executeGet(String targetURL, SocialHttpClient.POLICY authPolicy) throws SocialHttpClientException {
        return SocialHttpClientSupport.executeGet(targetURL, authPolicy, null);
    }

    public static HttpResponse executePost(String targetURL, SocialHttpClient.POLICY authPolicy, HttpParams params, Model model) throws SocialHttpClientException {
        HttpHost targetHost = new HttpHost(SocialClientContext.getHost(), SocialClientContext.getPort(), SocialClientContext.getProtocol());
        SocialHttpClient httpClient = SocialHttpClientImpl.newInstance();
        if (SocialHttpClient.POLICY.BASIC_AUTH == authPolicy) {
            httpClient.setBasicAuthenticateToRequest();
        }
        HttpPost httpPost = new HttpPost(targetURL);
        BasicHeader header = new BasicHeader("Content-Type", "application/json");
        httpPost.setHeader((Header)header);
        if (params != null) {
            httpPost.setParams(params);
        }
        try {
            byte[] postData = SocialHttpClientSupport.convertModelToByteArray(model);
            if (postData != null) {
                ByteArrayEntity entity = new ByteArrayEntity(SocialHttpClientSupport.convertModelToByteArray(model));
                httpPost.setEntity((HttpEntity)entity);
            }
            HttpResponse response = httpClient.execute(targetHost, (HttpRequest)httpPost);
            SocialHttpClientSupport.handleError(response);
            if (SocialClientContext.isDeveloping()) {
                SocialHttpClientSupport.dumpHttpResponsetHeader(response);
                SocialHttpClientSupport.dumpContent(response);
            }
            return response;
        }
        catch (ClientProtocolException cpex) {
            throw new SocialHttpClientException(cpex.toString(), cpex);
        }
        catch (IOException ioex) {
            throw new SocialHttpClientException(ioex.toString(), ioex);
        }
    }

    public static HttpResponse executePost(String targetURL, SocialHttpClient.POLICY authPolicy, HttpParams params) throws SocialHttpClientException {
        return SocialHttpClientSupport.executePost(targetURL, authPolicy, params, null);
    }

    public static HttpResponse executePost(String targetURL, SocialHttpClient.POLICY authPolicy, Model model) throws SocialHttpClientException {
        return SocialHttpClientSupport.executePost(targetURL, authPolicy, null, model);
    }

    public static HttpResponse executePost(String targetURL, SocialHttpClient.POLICY authPolicy) throws SocialHttpClientException {
        return SocialHttpClientSupport.executePost(targetURL, authPolicy, null, null);
    }

    public static HttpResponse executeDelete(String targetURL, SocialHttpClient.POLICY authPolicy, HttpParams params) throws SocialHttpClientException {
        HttpHost targetHost = new HttpHost(SocialClientContext.getHost(), SocialClientContext.getPort(), SocialClientContext.getProtocol());
        SocialHttpClient httpClient = SocialHttpClientImpl.newInstance();
        if (SocialHttpClient.POLICY.BASIC_AUTH == authPolicy) {
            httpClient.setBasicAuthenticateToRequest();
        }
        HttpDelete httpDelete = new HttpDelete(targetURL);
        BasicHeader header = new BasicHeader("Content-Type", "application/json");
        httpDelete.setHeader((Header)header);
        if (params != null) {
            httpDelete.setParams(params);
        }
        try {
            HttpResponse response = httpClient.execute(targetHost, (HttpRequest)httpDelete);
            SocialHttpClientSupport.handleError(response);
            if (SocialClientContext.isDeveloping()) {
                SocialHttpClientSupport.dumpHttpResponsetHeader(response);
                SocialHttpClientSupport.dumpContent(response);
            }
            return response;
        }
        catch (ClientProtocolException cpex) {
            throw new SocialHttpClientException(cpex.toString(), cpex);
        }
        catch (IOException ioex) {
            throw new SocialHttpClientException(ioex.toString(), ioex);
        }
    }

    public static HttpResponse executeDelete(String targetURL, SocialHttpClient.POLICY authPolicy) throws SocialHttpClientException {
        return SocialHttpClientSupport.executeDelete(targetURL, authPolicy, null);
    }

    public static byte[] convertModelToByteArray(Model model) throws IOException {
        if (model == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        model.writeJSONString(writer);
        return writer.getBuffer().toString().getBytes("UTF-8");
    }

    public static HttpEntity processContent(HttpResponse response) throws SocialHttpClientException {
        if (response == null) {
            throw new NullPointerException("HttpResponse argument is not NULL.");
        }
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.isStreaming()) {
            try {
                entity = new BufferedHttpEntity(entity);
                response.setEntity(entity);
            }
            catch (IOException ioex) {
                throw new SocialHttpClientException(ioex.toString(), ioex);
            }
        }
        return entity;
    }

    public static String getContent(HttpResponse response) throws SocialHttpClientException {
        String content;
        if (response == null) {
            throw new NullPointerException("HttpResponse argument is not NULL.");
        }
        HttpEntity entity = SocialHttpClientSupport.processContent(response);
        try {
            if (entity.getContentLength() == -1L) {
                throw new SocialHttpClientException("Content of response is empty.");
            }
            content = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException ioex) {
            throw new SocialHttpClientException(ioex.toString(), ioex);
        }
        return content;
    }

    public static void consume(HttpEntity entity) throws IllegalStateException, IOException {
        InputStream inputstream;
        if (entity.isStreaming() && (inputstream = entity.getContent()) != null) {
            inputstream.close();
        }
    }

    public static String buildCommonRestPathFromContext(boolean isPrivate) {
        String privateURL = "";
        if (isPrivate) {
            privateURL = "/private";
        }
        return "/" + SocialClientContext.getRestContextName() + privateURL + "/api/social/" + SocialClientContext.getRestVersion() + "/" + SocialClientContext.getPortalContainerName() + "/";
    }

    public static void handleError(HttpResponse response) throws SocialHttpClientException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new SocialHttpClientException(response.getStatusLine().toString());
        }
    }

    public static void dumpHttpResponsetHeader(HttpResponse response) {
        Header[] headers = response.getAllHeaders();
        System.out.println("\n\n++++++++++HEADER OF RESPONSE+++++++++++++++++++++++\n\n");
        for (int i = 0; i < headers.length; ++i) {
            System.out.println(headers[i].getName() + " : " + headers[i].getValue());
        }
    }

    public static void dumpContent(HttpResponse response) throws SocialHttpClientException {
        String responseContent = SocialHttpClientSupport.getContent(response);
        if (responseContent.length() > 0) {
            System.out.println("\n\n++++++++++CONTENT OF RESPONSE+++++++++++++++++++++++\n\n");
            System.out.println("RESPONSE CONTENT::" + responseContent);
            try {
                Map contentMap = SocialJSONDecodingSupport.parser(responseContent);
                Set list = contentMap.entrySet();
                for (Map.Entry e : list) {
                    System.out.println(e.getKey() + "::" + e.getValue());
                }
            }
            catch (ParseException pex) {
                throw new SocialHttpClientException("dumpContent() is parsing error.", pex);
            }
        }
    }
}

