/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.core.service;

import java.util.LinkedList;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.service.VersionService;
import org.exoplatform.social.client.core.util.SocialHttpClientSupport;
import org.exoplatform.social.client.core.util.SocialJSONDecodingSupport;

public class VersionServiceImpl
implements VersionService {
    private static final String VERSION_FIELD = "version";
    private static final String SUPPORTED_FIELD = "versions";

    @Override
    public String getLatest() throws ServiceException {
        String targetURL = "/" + SocialClientContext.getRestContextName() + "/api/social/version/latest.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.NO_AUTH);
            SocialHttpClientSupport.handleError(response);
            String content = SocialHttpClientSupport.getContent(response);
            Map versionMap = SocialJSONDecodingSupport.parser(content);
            return (String)versionMap.get(VERSION_FIELD);
        }
        catch (Exception pex) {
            throw new ServiceException(VersionServiceImpl.class, "Failed to getLatest version", pex);
        }
    }

    @Override
    public String[] getSupported() throws ServiceException {
        String targetURL = "/" + SocialClientContext.getRestContextName() + "/api/social/version/supported.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(targetURL, SocialHttpClient.POLICY.NO_AUTH);
            String content = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            Map versionMap = SocialJSONDecodingSupport.parser(content);
            LinkedList supportVersion = (LinkedList)versionMap.get(SUPPORTED_FIELD);
            return supportVersion.toArray(new String[0]);
        }
        catch (Exception pex) {
            throw new ServiceException(VersionServiceImpl.class, "Failed to getSupported versions", pex);
        }
    }
}

