/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.opensocial.spi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.opensocial.spi.ExoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoActivityService
extends ExoService
implements ActivityService {
    public static final String OPENSOCIAL_PREFIX = "opensocial:";
    public static final int OPENSOCIAL_PREFIX_LENGTH = "opensocial:".length();

    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws SocialSpiException {
        List result = Lists.newArrayList();
        PortalContainer pc = PortalContainer.getInstance();
        ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
        try {
            Set<Identity> idSet = this.getIdSet(userIds, groupId, token);
            for (Identity id : idSet) {
                result.addAll(this.convertToOSActivities(am.getActivities(id), fields));
            }
            this.sortActivity(result);
            int totalSize = result.size();
            int last = options.getFirst() + options.getMax();
            result = result.subList(options.getFirst(), Math.min(last, totalSize));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(result, 0, totalSize));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws SocialSpiException {
        List<Activity> result = Lists.newArrayList();
        try {
            String user = userId.getUserId(token);
            Identity id = this.getIdentity(user);
            PortalContainer pc = PortalContainer.getInstance();
            ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
            List exoActivities = am.getActivities(id);
            for (org.exoplatform.social.core.activitystream.model.Activity exoActivity : exoActivities) {
                if (exoActivity.getType() == null || !exoActivity.getType().startsWith(OPENSOCIAL_PREFIX)) continue;
                if (activityIds.contains(exoActivity.getType().substring(OPENSOCIAL_PREFIX_LENGTH))) {
                    // empty if block
                }
                result.add(this.convertToOSActivity(exoActivity, fields));
            }
            int totalSize = result.size();
            int last = options.getFirst() + options.getMax();
            result = result.subList(options.getFirst(), Math.min(last, totalSize));
            return ImmediateFuture.newInstance((Object)new RestfulCollection((List)result, 0, totalSize));
        }
        catch (Exception je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws SocialSpiException {
        throw new ProtocolException(501, null);
    }

    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws SocialSpiException {
        throw new ProtocolException(501, null);
    }

    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken token) throws SocialSpiException {
        try {
            org.exoplatform.social.core.activitystream.model.Activity exoActivity = this.convertFromOSActivity(activity, fields);
            PortalContainer pc = PortalContainer.getInstance();
            ActivityManager am = (ActivityManager)pc.getComponentInstanceOfType(ActivityManager.class);
            am.saveActivity(userId.getUserId(token), exoActivity);
            return ImmediateFuture.newInstance(null);
        }
        catch (Exception e) {
            throw new ProtocolException(500, e.getMessage(), (Throwable)e);
        }
    }

    private org.exoplatform.social.core.activitystream.model.Activity convertFromOSActivity(Activity activity, Set<String> fields) {
        org.exoplatform.social.core.activitystream.model.Activity exoActivity = new org.exoplatform.social.core.activitystream.model.Activity();
        exoActivity.setBody(activity.getBody());
        exoActivity.setExternalId(activity.getExternalId());
        exoActivity.setId(activity.getId());
        if (activity.getPriority() != null) {
            exoActivity.setPriority(Integer.valueOf(new Float(activity.getPriority().floatValue() * 100.0f).intValue()));
        }
        exoActivity.setTitle(activity.getTitle());
        exoActivity.setType(OPENSOCIAL_PREFIX + activity.getAppId());
        exoActivity.setUrl(activity.getUrl());
        exoActivity.setUserId(activity.getUserId());
        return exoActivity;
    }

    private Activity convertToOSActivity(org.exoplatform.social.core.activitystream.model.Activity exoActivity, Set<String> fields) {
        ActivityImpl activity = new ActivityImpl();
        activity.setBody(exoActivity.getBody());
        activity.setExternalId(exoActivity.getExternalId());
        activity.setId(exoActivity.getId());
        if (exoActivity.getPriority() != null) {
            activity.setPriority(Float.valueOf((float)exoActivity.getPriority().intValue() / 100.0f));
        }
        activity.setTitle(exoActivity.getTitle());
        if (exoActivity.getType() != null && exoActivity.getType().startsWith(OPENSOCIAL_PREFIX)) {
            activity.setAppId(exoActivity.getType().substring(OPENSOCIAL_PREFIX_LENGTH));
        }
        activity.setUrl(exoActivity.getUrl());
        activity.setUserId(exoActivity.getUserId());
        activity.setUpdated(new Date(exoActivity.getUpdated()));
        activity.setPostedTime(exoActivity.getPostedTime());
        return activity;
    }

    private List<Activity> convertToOSActivities(List<org.exoplatform.social.core.activitystream.model.Activity> activities, Set<String> fields) {
        ArrayList res = Lists.newArrayList();
        for (org.exoplatform.social.core.activitystream.model.Activity activity : activities) {
            res.add(this.convertToOSActivity(activity, fields));
        }
        return res;
    }

    private List<Activity> sortActivity(List<Activity> lstActivities) {
        Collections.sort(lstActivities, new ActivityComparator());
        return lstActivities;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActivityComparator
    implements Comparator<Activity> {
        private ActivityComparator() {
        }

        @Override
        public int compare(Activity act1, Activity act2) {
            return (int)(act2.getPostedTime() - act1.getPostedTime());
        }
    }
}

