/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Property;
import org.exoplatform.social.core.relationship.Relationship;
import org.exoplatform.social.core.relationship.storage.JCRStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipManager {
    private JCRStorage storage;

    public RelationshipManager(NodeHierarchyCreator nodeHierarchyCreator, IdentityManager im) throws Exception {
        this.storage = new JCRStorage(nodeHierarchyCreator, im);
    }

    public Relationship getById(String id) throws Exception {
        return this.storage.getRelationship(id);
    }

    public void confirm(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.CONFIRM);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.CONFIRM);
        }
        this.save(relationship);
    }

    public void ignore(Relationship relationship) throws Exception {
        relationship.setStatus(Relationship.Type.IGNORE);
        for (Property prop : relationship.getProperties()) {
            prop.setStatus(Relationship.Type.IGNORE);
        }
        this.save(relationship);
    }

    public List<Relationship> getPending(Identity identity) throws Exception {
        List<Relationship> rels = this.get(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        for (Relationship rel : rels) {
            if (rel.getStatus() == Relationship.Type.PENDING) {
                pendingRel.add(rel);
                continue;
            }
            if (rel.getProperties(Relationship.Type.PENDING).size() <= 0) continue;
            pendingRel.add(rel);
        }
        return pendingRel;
    }

    public List<Relationship> getPending(Identity identity, boolean toConfirm) throws Exception {
        List<Relationship> rels = this.get(identity);
        ArrayList<Relationship> pendingRel = new ArrayList<Relationship>();
        block0: for (Relationship rel : rels) {
            if (rel.getStatus() == Relationship.Type.PENDING && !toConfirm) {
                pendingRel.add(rel);
                continue;
            }
            if (rel.getStatus() == Relationship.Type.PENDING && toConfirm && !identity.getId().equals(rel.getIdentity1().getId())) {
                pendingRel.add(rel);
                continue;
            }
            List<Property> props = rel.getProperties(Relationship.Type.PENDING);
            for (Property prop : props) {
                if (toConfirm != prop.getInitiator().getId().equals(identity.getId())) continue;
                pendingRel.add(rel);
                continue block0;
            }
        }
        return pendingRel;
    }

    public List<Relationship> getContacts(Identity identity) throws Exception {
        List<Relationship> rels = this.get(identity);
        ArrayList<Relationship> contacts = new ArrayList<Relationship>();
        for (Relationship rel : rels) {
            if (rel.getStatus() != Relationship.Type.CONFIRM) continue;
            contacts.add(rel);
        }
        return contacts;
    }

    public List<Relationship> get(Identity id) throws Exception {
        return this.storage.getRelationshipByIdentity(id);
    }

    public List<Relationship> getByIdentityId(String id) throws Exception {
        return this.storage.getRelationshipByIdentityId(id);
    }

    public List<Identity> getIdentities(Identity id) throws Exception {
        return this.storage.getRelationshipIdentitiesByIdentity(id);
    }

    public Relationship create(Identity id1, Identity id2) {
        return new Relationship(id1, id2);
    }

    public void save(Relationship rel) throws Exception {
        if (rel.getIdentity1().getId().equals(rel.getIdentity2().getId())) {
            throw new Exception("the two identity are the same");
        }
        for (Property prop : rel.getProperties()) {
            if (prop.getInitiator().getId().equals(rel.getIdentity1().getId()) || prop.getInitiator().getId().equals(rel.getIdentity2().getId())) continue;
            throw new Exception("the property initiator is not member of the relationship");
        }
        this.storage.saveRelationship(rel);
    }

    public List findRoute(Identity id1, Identity id2) {
        return null;
    }

    public Relationship getRelationship(Identity id1, Identity id2) throws Exception {
        List<Relationship> rels = this.get(id1);
        String sId2 = id2.getId();
        for (Relationship rel : rels) {
            if (!rel.getIdentity1().getId().equals(sId2) && !rel.getIdentity2().getId().equals(sId2)) continue;
            return rel;
        }
        return null;
    }
}

