/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activitystream;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.space.JCRSessionManager;
import org.exoplatform.social.space.impl.SocialDataLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRStorage {
    private static final String PUBLISHED_NODE = "published".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String ACTIVITY_NODETYPE = "exo:activity".intern();
    private static final String BODY = "exo:body".intern();
    private static final String EXTERNAL_ID = "exo:externalId".intern();
    private static final String ID = "exo:id".intern();
    private static final String UPDATED = "exo:updated".intern();
    private static final String POSTED_TIME = "exo:postedTime".intern();
    private static final String PRIORITY = "exo:priority".intern();
    private static final String TITLE = "exo:title".intern();
    private static final String URL = "exo:url".intern();
    private static final String USER_ID = "exo:userId".intern();
    private static final String TYPE = "exo:type".intern();
    private static final String HIDDEN = "exo:hidden".intern();
    private static final String LIKE_IDENTITY_IDS = "exo:like".intern();
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;

    public JCRStorage(SocialDataLocation dataLocation) {
        this.dataLocation = dataLocation;
        this.sessionManager = dataLocation.getSessionManager();
    }

    private Node getActivityServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialActivitiesHome();
        return session.getRootNode().getNode(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getUserActivityServiceHome(String username) {
        Session session = this.sessionManager.openSession();
        try {
            Node activityHomeNode = this.getActivityServiceHome(session);
            if (activityHomeNode.hasNode(username)) {
                Node node = activityHomeNode.getNode(username);
                return node;
            }
            Node appNode = activityHomeNode.addNode(username, NT_UNSTRUCTURED);
            activityHomeNode.save();
            Node node = appNode;
            return node;
        }
        catch (Exception e) {
            Node node = null;
            return node;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    private Node getPublishedActivityServiceHome(String username) {
        try {
            Node userActivityHomeNode = this.getUserActivityServiceHome(username);
            try {
                return userActivityHomeNode.getNode(PUBLISHED_NODE);
            }
            catch (PathNotFoundException ex) {
                Node appNode = userActivityHomeNode.addNode(PUBLISHED_NODE, NT_UNSTRUCTURED);
                userActivityHomeNode.save();
                return appNode;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity save(String user, Activity activity) throws Exception {
        Node activityHomeNode = this.getPublishedActivityServiceHome(user);
        try {
            Node activityNode;
            Session session = this.sessionManager.openSession();
            if (activity.getId() == null) {
                activityNode = activityHomeNode.addNode(ACTIVITY_NODETYPE, ACTIVITY_NODETYPE);
                activityNode.addMixin("mix:referenceable");
            } else {
                activityNode = session.getNodeByUUID(activity.getId());
            }
            if (activity.getBody() != null) {
                activityNode.setProperty(BODY, activity.getBody());
            }
            if (activity.getExternalId() != null) {
                activityNode.setProperty(EXTERNAL_ID, activity.getExternalId());
            }
            if (activity.getPostedTime() != null) {
                activityNode.setProperty(POSTED_TIME, activity.getPostedTime().longValue());
            }
            if (activity.getPriority() != null) {
                activityNode.setProperty(PRIORITY, (long)activity.getPriority().intValue());
            }
            if (activity.getTitle() != null) {
                activityNode.setProperty(TITLE, activity.getTitle());
            }
            if (activity.getUpdated() != null) {
                activityNode.setProperty(UPDATED, activity.getUpdated().longValue());
            }
            if (activity.getUserId() != null) {
                activityNode.setProperty(USER_ID, activity.getUserId());
            }
            if (activity.getType() != null) {
                activityNode.setProperty(TYPE, activity.getType());
            }
            if (activity.getUrl() != null) {
                activityNode.setProperty(URL, activity.getUrl());
            }
            activityNode.setProperty(LIKE_IDENTITY_IDS, activity.getLikeIdentityIds());
            activityNode.setProperty(HIDDEN, activity.isHidden());
            if (activity.getId() == null) {
                activityHomeNode.save();
                activity.setId(activityNode.getUUID());
            } else {
                activityNode.save();
            }
        }
        catch (Exception e) {
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteActivity(String activityId) throws Exception {
        Session session = this.sessionManager.openSession();
        Node activityNode = null;
        try {
            activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                activityNode.remove();
                session.save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity load(String id) {
        Session session = this.sessionManager.openSession();
        try {
            Node activityNode = session.getNodeByUUID(id);
            if (activityNode != null) {
                Activity activity = this.load(activityNode);
                return activity;
            }
        }
        catch (Exception e) {
            Activity activity = null;
            return activity;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    private Activity load(Node n) throws Exception {
        Activity activity = new Activity();
        activity.setId(n.getUUID());
        if (n.hasProperty(BODY)) {
            activity.setBody(n.getProperty(BODY).getString());
        }
        if (n.hasProperty(EXTERNAL_ID)) {
            activity.setExternalId(n.getProperty(EXTERNAL_ID).getString());
        }
        if (n.hasProperty(HIDDEN)) {
            activity.setHidden(n.getProperty(HIDDEN).getBoolean());
        }
        if (n.hasProperty(POSTED_TIME)) {
            activity.setPostedTime(n.getProperty(POSTED_TIME).getLong());
        }
        if (n.hasProperty(PRIORITY)) {
            activity.setPriority((int)n.getProperty(PRIORITY).getLong());
        }
        if (n.hasProperty(TITLE)) {
            activity.setTitle(n.getProperty(TITLE).getString());
        }
        if (n.hasProperty(TYPE)) {
            activity.setType(n.getProperty(TYPE).getString());
        }
        if (n.hasProperty(UPDATED)) {
            activity.setUpdated(n.getProperty(UPDATED).getLong());
        }
        if (n.hasProperty(URL)) {
            activity.setUrl(n.getProperty(URL).getString());
        }
        if (n.hasProperty(USER_ID)) {
            activity.setUserId(n.getProperty(USER_ID).getString());
        }
        if (n.hasProperty(LIKE_IDENTITY_IDS)) {
            activity.setLikeIdentityIds(this.ValuesToStrings(n.getProperty(LIKE_IDENTITY_IDS).getValues()));
        }
        return activity;
    }

    public List<Activity> getActivities(Identity identity) throws Exception {
        ArrayList activities = Lists.newArrayList();
        Node n = this.getPublishedActivityServiceHome(identity.getId());
        NodeIterator nodes = n.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            if (node.hasProperty(EXTERNAL_ID)) {
                String externalId = node.getProperty(EXTERNAL_ID).getString();
                if (externalId.equals(Activity.IS_COMMENT)) continue;
                activities.add(this.load(node));
                continue;
            }
            activities.add(this.load(node));
        }
        return activities;
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }
}

