/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.relationship;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Relationship {
    private String id;
    private List<Property> properties;
    private Identity identity1;
    private Identity identity2;
    private Type status = Type.PENDING;

    public Relationship(Identity identity1, Identity identity2) {
        this(identity1, identity2, new ArrayList<Property>());
    }

    public Relationship(Identity identity1, Identity identity2, List<Property> properties) {
        this.identity1 = identity1;
        this.identity2 = identity2;
        this.properties = properties;
    }

    public Relationship(String uuid) {
        this.id = uuid;
        this.properties = new ArrayList<Property>();
    }

    public Identity getIdentity1() {
        return this.identity1;
    }

    public Identity getIdentity2() {
        return this.identity2;
    }

    public void setIdentity1(Identity identity1) {
        this.identity1 = identity1;
    }

    public void setIdentity2(Identity identity2) {
        this.identity2 = identity2;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Type getStatus() {
        return this.status;
    }

    public void setStatus(Type status) {
        this.status = status;
    }

    public List<Property> getProperties(Type status) {
        ArrayList<Property> pendingProps = new ArrayList<Property>();
        for (Property prop : this.properties) {
            if (prop.getStatus() != status) continue;
            pendingProps.add(prop);
        }
        return pendingProps;
    }

    public String toString() {
        return this.identity1 + "--[" + (Object)((Object)this.status) + "]--" + this.identity2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PENDING,
        CONFIRM,
        IGNORE,
        ALIEN,
        REQUIRE_VALIDATION,
        SELF;

    }
}

