/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIActivityComposerContainer;
import org.exoplatform.social.webui.composer.UIActivityComposerManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/composer/UIComposer.gtmpl", events={@EventConfig(listeners={PostMessageActionListener.class}), @EventConfig(listeners={ActivateActionListener.class})})
public class UIComposer
extends UIForm {
    private UIContainer optionContainer;
    private PostContext postContext;
    private UIFormTextAreaInput messageInput = new UIFormTextAreaInput("composerInput", "composerInput", null);
    private UIActivityComposerContainer composerContainer;
    private UIActivityComposerManager activityComposerManager;

    public UIComposer() throws Exception {
        this.addUIFormInput((UIFormInput)this.messageInput);
        this.composerContainer = (UIActivityComposerContainer)this.addChild(UIActivityComposerContainer.class, null, null);
        this.activityComposerManager = new UIActivityComposerManager();
        if (!this.activityComposerManager.isInitialized()) {
            this.initActivityComposerManager();
        }
        this.activityComposerManager.setDefaultActivityComposer();
    }

    private void initActivityComposerManager() throws Exception {
        UIExtensionManager uiExtensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);
        List extensionList = uiExtensionManager.getUIExtensions(UIActivityComposer.class.getName());
        int j = extensionList.size();
        for (int i = 0; i < j; ++i) {
            UIExtension composerExtension = (UIExtension)extensionList.get(i);
            if (composerExtension.getName().equals("DEFAULT_ACTIVITY_COMPOSER")) {
                UIActivityComposer uiDefaultComposer = (UIActivityComposer)uiExtensionManager.addUIExtension(composerExtension, null, (UIContainer)this.composerContainer);
                this.composerContainer.removeChildById(uiDefaultComposer.getId());
                uiDefaultComposer.setRendered(false);
                uiDefaultComposer.setActivityComposerManager(this.activityComposerManager);
                this.activityComposerManager.setDefaultActivityComposer(uiDefaultComposer);
                continue;
            }
            UIActivityComposer uiActivityComposer = (UIActivityComposer)uiExtensionManager.addUIExtension(composerExtension, null, (UIContainer)this.composerContainer);
            uiActivityComposer.setRendered(false);
            uiActivityComposer.setActivityComposerManager(this.activityComposerManager);
            this.activityComposerManager.registerActivityComposer(uiActivityComposer);
        }
        this.activityComposerManager.setInitialized();
    }

    public void setActivityDisplay(UIContainer uiContainer) {
        this.activityComposerManager.setActivityDisplay(uiContainer);
    }

    public void setDefaultActivityComposer() {
        this.activityComposerManager.setDefaultActivityComposer();
    }

    public UIActivityComposerContainer getComposerContainer() {
        return this.composerContainer;
    }

    public UIActivityComposerManager getActivityComposerManager() {
        return this.activityComposerManager;
    }

    public List<UIActivityComposer> getActivityComposers() {
        return this.activityComposerManager.getAllComposers();
    }

    public String getMessage() {
        return (String)((UIFormTextAreaInput)this.getChild(UIFormTextAreaInput.class)).getValue();
    }

    public PostContext getPostContext() {
        return this.postContext;
    }

    public void setPostContext(PostContext postContext) {
        this.postContext = postContext;
    }

    public void setOptionContainer(UIContainer optionContainer) {
        this.optionContainer = optionContainer;
    }

    public UIContainer getOptionContainer() {
        return this.optionContainer;
    }

    public String getActivateEvent(String activityComposerId) {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String activityComposerFormId = context instanceof PortletRequestContext ? ((PortletRequestContext)context).getWindowId() + "#" + activityComposerId : activityComposerId;
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.webui.UIForm.submitForm('").append(activityComposerFormId).append("','");
        b.append("Activate").append("',true)");
        return b.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActivateActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIComposer composer = (UIComposer)((UIActivityComposer)((Object)event.getSource())).getAncestorOfType(UIComposer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)composer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostMessageActionListener
    extends EventListener<UIComposer> {
        public void execute(Event<UIComposer> event) throws Exception {
            UIComposer uiComposer = (UIComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = uiComposer.getActivityComposerManager();
            PostContext postContext = uiComposer.getPostContext();
            UIActivityComposer activityComposer = activityComposerManager.getCurrentActivityComposer();
            String message = uiComposer.getMessage().trim();
            String defaultInput = "";
            defaultInput = uiComposer.getPostContext() == PostContext.SPACE ? event.getRequestContext().getApplicationResourceBundle().getString(uiComposer.getId() + ".input.Write_Something") : event.getRequestContext().getApplicationResourceBundle().getString(uiComposer.getId() + ".input.What_Are_You_Working_On");
            if (message.equals(defaultInput)) {
                message = "";
            }
            UIFormTextAreaInput messageInput = (UIFormTextAreaInput)uiComposer.getChild(UIFormTextAreaInput.class);
            messageInput.setValue((Object)"");
            WebuiRequestContext requestContext = event.getRequestContext();
            activityComposer.postActivity(postContext, (UIComponent)uiComposer, requestContext, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostContext {
        SPACE,
        USER;

    }
}

