/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.social.webui.space.UISpaceInfo;
import org.exoplatform.social.webui.space.UISpaceMember;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpacePermission;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceSetting.gtmpl"), @ComponentConfig(type=UITabPane.class, id="UISpaceSettingTabPane", template="system:/groovy/webui/core/UITabPane_New.gtmpl", events={@EventConfig(listeners={SelectTabActionListener.class})})})
public class UISpaceSetting
extends UIContainer {
    private Space space;

    public UISpaceSetting() throws Exception {
        UITabPane uiTabPane = (UITabPane)this.addChild(UITabPane.class, null, null);
        uiTabPane.setComponentConfig(UITabPane.class, "UISpaceSettingTabPane");
        uiTabPane.addChild(UISpaceInfo.class, null, null);
        uiTabPane.addChild(UISpacePermission.class, null, null);
        uiTabPane.addChild(UISpaceMember.class, null, null);
        uiTabPane.addChild(UISpaceApplication.class, null, null);
        uiTabPane.addChild(UISpaceNavigationManagement.class, null, null);
        uiTabPane.setSelectedTab(1);
    }

    public void setValues(Space space) throws Exception {
        UISpaceInfo uiSpaceInfo = (UISpaceInfo)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceInfo.class);
        uiSpaceInfo.setValue(space);
        UISpaceMember uiSpaceMember = (UISpaceMember)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceMember.class);
        uiSpaceMember.setValue(space.getId());
        UISpaceApplication uiSpaceApplication = (UISpaceApplication)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpaceApplication.class);
        uiSpaceApplication.setValue(space);
        UISpacePermission uiSpacePermission = (UISpacePermission)((UITabPane)this.getChild(UITabPane.class)).getChild(UISpacePermission.class);
        uiSpacePermission.setValue(space);
        this.space = space;
    }

    public String getSpaceName() {
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        try {
            return spaceSrc.getSpaceById(this.space.getId()).getName();
        }
        catch (SpaceException e) {
            return null;
        }
    }

    public boolean isLeader() throws Exception {
        String userId;
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        return spaceSrc.hasEditPermission(this.space, userId = Util.getPortalRequestContext().getRemoteUser());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectTabActionListener
    extends EventListener<UITabPane> {
        public void execute(Event<UITabPane> event) throws Exception {
            UISpaceApplication uiApplication;
            UITabPane uiTabPane = (UITabPane)event.getSource();
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            if (!renderTab.equals(UISpaceApplication.class.getSimpleName()) && (uiApplication = (UISpaceApplication)uiTabPane.getChild(UISpaceApplication.class)) != null) {
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiApplication.getChild(UIPopupContainer.class);
                uiPopupContainer.deActivate();
            }
            uiTabPane.setSelectedTab(renderTab);
            context.setResponseComplete(true);
        }
    }
}

