/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.benches;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.extras.benches.DataInjector;
import org.picocontainer.Startable;

public class StartupInjectionConfig
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(StartupInjectionConfig.class);
    private long people = 0L;
    private long relations = 0L;
    private long activities = 0L;
    private long spaces = 0L;
    private long membersPerSpace = 0L;
    private Map<String, Long> userActivities = new HashMap<String, Long>();
    private DataInjector injector;

    public StartupInjectionConfig(InitParams params, DataInjector injector, OrganizationService organizationService) {
        this.injector = injector;
        PropertiesParam props = params.getPropertiesParam("inject.conf");
        if (props != null) {
            Iterator it = props.getPropertyIterator();
            while (it.hasNext()) {
                Property property = (Property)it.next();
                String name = property.getName();
                String value = property.getValue();
                Long longValue = this.longValue(name, value);
                if ("people".equals(name)) {
                    this.people = longValue;
                }
                if ("relations".equals(name)) {
                    this.relations = longValue;
                }
                if ("activities".equals(name)) {
                    this.activities = longValue;
                }
                if (name.contains(".activities")) {
                    String user = name.substring(0, name.indexOf(".activities"));
                    this.userActivities.put(user, longValue);
                }
                if ("spaces".equals(name)) {
                    this.spaces = longValue;
                }
                if (!"spaces.members".equals(name)) continue;
                this.membersPerSpace = longValue;
            }
        }
    }

    private long getLongProperty(PropertiesParam props, String property) {
        String value = props.getProperty(property);
        return this.longValue(property, value);
    }

    private long longValue(String property, String value) {
        try {
            if (value != null) {
                return Long.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Long number expected for property " + property));
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.inject();
        }
        catch (Exception e) {
            LOG.error((Object)"Data injeciton failed", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void inject() {
        LOG.info((Object)"starting...");
        boolean nothingWasDone = true;
        if (this.people > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.people + " people."));
            this.injector.generatePeople(this.people);
        }
        if (this.relations > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.relations + " connections."));
            this.injector.generateRelations(this.relations);
        }
        if (this.activities > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.activities + " activities."));
            this.injector.generateActivities(this.activities);
        }
        if (this.spaces > 0L) {
            nothingWasDone = false;
            LOG.info((Object)("\t> about to inject " + this.spaces + " spaces."));
            Collection<Space> spacesCreated = this.injector.generateSpaces(this.spaces);
            if (this.membersPerSpace > 0L) {
                LOG.info((Object)("\t> about to inject " + this.membersPerSpace + " per space."));
                this.injector.inviteMembers(spacesCreated, this.membersPerSpace);
            }
        }
        if (!this.userActivities.isEmpty()) {
            Set<Map.Entry<String, Long>> entries = this.userActivities.entrySet();
            for (Map.Entry<String, Long> entry : entries) {
                String username = entry.getKey();
                Long count = entry.getValue();
                LOG.info((Object)("\t> about to inject " + count + " activities for " + username + "."));
                this.injector.generateActivities(username, count);
            }
        }
        if (nothingWasDone) {
            LOG.info((Object)"nothing to inject.");
        }
    }

    public void stop() {
    }
}

