/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.impl.ActivityStorageImpl;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.exoplatform.social.core.storage.impl.RelationshipStorageImpl;
import org.exoplatform.social.core.storage.impl.SpaceStorageImpl;
import org.exoplatform.social.extras.migration.io.WriterContext;
import org.exoplatform.social.extras.migration.rw.NodeReader;
import org.exoplatform.social.extras.migration.rw.NodeWriter;

public class MigrationTool {
    public static final int START_NODE = 1;
    public static final int PROPERTY_SINGLE = 2;
    public static final int PROPERTY_MULTI = 3;
    public static final int END_NODE = 4;
    private final IdentityStorage identityStorage;
    private final RelationshipStorage relationshipStorage;
    private final SpaceStorage spaceStorage;
    private final ActivityStorage activityStorage;
    private final OrganizationService organizationService;

    public MigrationTool() {
        PortalContainer container = PortalContainer.getInstance();
        this.identityStorage = (IdentityStorage)container.getComponentInstanceOfType(IdentityStorageImpl.class);
        this.relationshipStorage = (RelationshipStorage)container.getComponentInstanceOfType(RelationshipStorageImpl.class);
        this.spaceStorage = (SpaceStorage)container.getComponentInstanceOfType(SpaceStorageImpl.class);
        this.activityStorage = (ActivityStorage)container.getComponentInstanceOfType(ActivityStorageImpl.class);
        this.organizationService = (OrganizationService)container.getComponentInstance(OrganizationService.class);
    }

    public void runAll(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        this.runIdentities(reader, writer, ctx);
        this.runSpaces(reader, writer, ctx);
        this.runProfiles(reader, writer, ctx);
        this.runRelationships(reader, writer, ctx);
        this.runActivities(reader, writer, ctx);
    }

    public void runIdentities(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        reader.checkData();
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        reader.readIdentities(os, ctx);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        writer.writeIdentities(is, ctx);
        RequestLifeCycle.end();
    }

    public void runProfiles(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        reader.checkData();
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        reader.readProfiles(os, ctx);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        writer.writeProfiles(is, ctx);
        RequestLifeCycle.end();
    }

    public void runSpaces(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        reader.checkData();
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        reader.readSpaces(os, ctx);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        writer.writeSpaces(is, ctx);
        RequestLifeCycle.end();
    }

    public void runRelationships(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        reader.checkData();
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        reader.readRelationships(os, ctx);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        writer.writeRelationships(is, ctx);
        RequestLifeCycle.end();
    }

    public void runActivities(NodeReader reader, NodeWriter writer, WriterContext ctx) throws IOException, RepositoryException {
        reader.checkData();
        PipedOutputStream os = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(os);
        reader.readActivities(os, ctx);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        writer.writeActivities(is, ctx);
        RequestLifeCycle.end();
    }

    public void rollback(NodeReader reader, NodeWriter writer, WriterContext ctx) throws RepositoryException {
        writer.rollback(ctx);
    }

    public void commit(NodeReader reader, NodeWriter writer, WriterContext ctx) throws RepositoryException {
        writer.commit(ctx);
    }

    public NodeReader createReader(String from, String to, Session session) throws RepositoryException {
        try {
            Class<?> clazz = Class.forName("org.exoplatform.social.extras.migration.rw." + this.buildName(from, to, "Reader"));
            Constructor<?> c = clazz.getConstructor(Session.class);
            return (NodeReader)c.newInstance(session);
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeWriter createWriter(String from, String to, Session session) throws RepositoryException {
        try {
            Class<?> clazz = Class.forName("org.exoplatform.social.extras.migration.rw." + this.buildName(from, to, "Writer"));
            Constructor<?> c = clazz.getConstructor(IdentityStorage.class, RelationshipStorage.class, SpaceStorage.class, ActivityStorage.class, OrganizationService.class, Session.class);
            return (NodeWriter)c.newInstance(this.identityStorage, this.relationshipStorage, this.spaceStorage, this.activityStorage, this.organizationService, session);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String buildName(String from, String to, String type) {
        return String.format("Node%s_%s_%s", type, from, to);
    }
}

