/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import javax.annotation.PostConstruct;
import javax.ejb.PostActivate;
import javax.persistence.EntityManager;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.persistence.EntityManagerProxy;
import org.jboss.seam.persistence.PersistenceProvider;

@Interceptor(stateless=true)
public class EntityManagerProxyInterceptor
extends AbstractInterceptor {
    @AroundInvoke
    public Object aroundInvoke(InvocationContext ic) throws Exception {
        return ic.proceed();
    }

    @PostActivate
    public void postActivate(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext invocation) throws Exception {
        this.proxyPersistenceContexts(invocation.getTarget());
        invocation.proceed();
    }

    private void proxyPersistenceContexts(Object bean) {
        for (Component.BijectedAttribute ba : this.getComponent().getPersistenceContextAttributes()) {
            Object object = ba.get(bean);
            if (object instanceof EntityManagerProxy || !(object instanceof EntityManager)) continue;
            PersistenceProvider provider = PersistenceProvider.instance();
            ba.set(bean, provider.proxyEntityManager((EntityManager)object));
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().getType() == ComponentType.STATEFUL_SESSION_BEAN || this.getComponent().getType() == ComponentType.STATELESS_SESSION_BEAN;
    }
}

