/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.command.lock.LockRequestEntity;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LockCommand {
    private static Log log = ExoLogger.getLogger(LockCommand.class);
    private final NullResourceLocksHolder nullResourceLocks;

    public LockCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response lock(Session session, String path, HierarchicalProperty body, Depth depth, String timeout) {
        try {
            String lockToken;
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            try {
                Node node = (Node)session.getItem(path);
                if (!node.isNodeType("mix:lockable") && node.canAddMixin("mix:lockable")) {
                    node.addMixin("mix:lockable");
                    session.save();
                }
                Lock lock = node.lock(depth.getIntValue() != 1, false);
                lockToken = lock.getLockToken();
            }
            catch (PathNotFoundException pexc) {
                lockToken = this.nullResourceLocks.addLock(session, path);
            }
            LockRequestEntity requestEntity = new LockRequestEntity(body);
            lockToken = "opaquelocktoken:" + lockToken;
            return Response.ok((Object)this.body(nsContext, requestEntity, depth, lockToken, requestEntity.getOwner(), timeout), (String)"text/xml").header("Lock-Token", (Object)("<" + lockToken + ">")).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).entity((Object)exc.getMessage()).build();
        }
        catch (AccessDeniedException exc) {
            return Response.status((int)403).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    private StreamingOutput body(WebDavNamespaceContext nsContext, LockRequestEntity input, Depth depth, String lockToken, String lockOwner, String timeout) {
        return new LockResultResponseEntity(nsContext, lockToken, lockOwner, timeout);
    }

    public class LockResultResponseEntity
    implements StreamingOutput {
        protected WebDavNamespaceContext nsContext;
        protected String lockToken;
        protected String lockOwner;
        protected String timeOut;

        public LockResultResponseEntity(WebDavNamespaceContext nsContext, String lockToken, String lockOwner, String timeOut) {
            this.nsContext = nsContext;
            this.lockToken = lockToken;
            this.lockOwner = lockOwner;
            this.timeOut = timeOut;
        }

        public void write(OutputStream stream) throws IOException {
            try {
                XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, "UTF-8");
                xmlStreamWriter.setNamespaceContext(this.nsContext);
                xmlStreamWriter.setDefaultNamespace("DAV:");
                xmlStreamWriter.writeStartDocument();
                xmlStreamWriter.writeStartElement("D", "prop", "DAV:");
                xmlStreamWriter.writeNamespace("D", "DAV:");
                HierarchicalProperty lockDiscovery = GenericResource.lockDiscovery(this.lockToken, this.lockOwner, this.timeOut);
                PropertyWriteUtil.writeProperty(xmlStreamWriter, lockDiscovery);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndDocument();
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
    }
}

