/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.composite;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.composite.ResourcePermission;

public class ResourceComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private Resource resource;
    @XmlElement
    private Resource parent;
    @XmlElement
    private ResourcePermission resourcePermission;
    @XmlElement
    private AvailabilityType availability;
    private ResourceFacets resourceFacets;

    public ResourceComposite() {
    }

    public ResourceComposite(Resource resource, AvailabilityType availability) {
        this(resource, null, availability, new ResourcePermission());
    }

    public ResourceComposite(Resource resource, Resource parent, AvailabilityType availability) {
        this(resource, parent, availability, new ResourcePermission());
    }

    public ResourceComposite(Resource resource, AvailabilityType availability, Number measure, Number inventory, Number control, Number alert, Number configure, Number content, Number createChildResources, Number deleteResources) {
        this(resource, null, availability, new ResourcePermission(measure.intValue() > 0, inventory.intValue() > 0, control.intValue() > 0, alert.intValue() > 0, configure.intValue() > 0, content.intValue() > 0, createChildResources.intValue() > 0, deleteResources.intValue() > 0));
    }

    public ResourceComposite(Resource resource, Resource parent, AvailabilityType availability, Number measure, Number inventory, Number control, Number alert, Number configure, Number content, Number createChildResources, Number deleteResources) {
        this(resource, parent, availability, new ResourcePermission(measure.intValue() > 0, inventory.intValue() > 0, control.intValue() > 0, alert.intValue() > 0, configure.intValue() > 0, content.intValue() > 0, createChildResources.intValue() > 0, deleteResources.intValue() > 0));
    }

    private ResourceComposite(Resource resource, Resource parent, AvailabilityType availability, ResourcePermission resourcePermission) {
        this.resource = resource;
        this.parent = parent;
        this.availability = availability;
        this.resourcePermission = resourcePermission;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getParent() {
        return this.parent;
    }

    public AvailabilityType getAvailability() {
        return this.availability;
    }

    public ResourcePermission getResourcePermission() {
        return this.resourcePermission;
    }

    @XmlTransient
    public ResourceFacets getResourceFacets() {
        return this.resourceFacets;
    }

    public void setResourceFacets(ResourceFacets facets) {
        this.resourceFacets = facets;
    }

    public String toString() {
        return "[ResourceComposite] Resource: " + this.resource + "\n\tAvailability: " + (Object)((Object)this.availability) + "\n\tPermissions: " + this.resourcePermission;
    }
}

