/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.policy;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
import org.jboss.ws.extensions.wsrm.config.RMConfig;
import org.jboss.ws.extensions.wsrm.config.RMDeliveryAssuranceConfig;
import org.jboss.ws.extensions.wsrm.config.RMPortConfig;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RM11PolicyAssertionDeployer
implements AssertionDeployer {
    private static final String WSRMP_NS = "http://docs.oasis-open.org/ws-rx/wsrmp/200702";
    private static final String WSRM_NS = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
    private static final QName EXACTLY_ONCE = new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "ExactlyOnce");
    private static final QName AT_LEAST_ONCE = new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "AtLeastOnce");
    private static final QName AT_MOST_ONCE = new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "AtMostOnce");
    private static final QName IN_ORDER = new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "InOrder");
    private static final String FALSE = "false";
    private static final String TRUE = "true";

    @Override
    public void deployClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        RM11PolicyAssertionDeployer.deploy(assertion, extMetaData);
    }

    @Override
    public void deployServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        RM11PolicyAssertionDeployer.deploy(assertion, extMetaData);
    }

    private static void deploy(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        if (extMetaData instanceof EndpointMetaData) {
            EndpointMetaData endpointMD = (EndpointMetaData)extMetaData;
            RMConfig rmMD = endpointMD.getConfig().getRMMetaData();
            if (rmMD == null) {
                rmMD = new RMConfig();
                endpointMD.getConfig().setRMMetaData(rmMD);
            }
            RMPortConfig portMD = new RMPortConfig();
            portMD.setPortName(endpointMD.getPortName());
            RMDeliveryAssuranceConfig deliveryMD = new RMDeliveryAssuranceConfig();
            deliveryMD.setInOrder(FALSE);
            deliveryMD.setQuality("AtLeastOnce");
            portMD.setDeliveryAssurance(deliveryMD);
            for (RMPortConfig pMD : rmMD.getPorts()) {
                assert (!pMD.getPortName().equals(portMD.getPortName()));
            }
            rmMD.getPorts().add(portMD);
            if (!WSRM_NS.equals(RMProvider.get().getNamespaceURI())) {
                throw new IllegalArgumentException("RM provider namespace mismatch");
            }
        }
    }

    private static RMDeliveryAssuranceConfig constructDeliveryAssurance(List<PrimitiveAssertion> assertions) throws UnsupportedAssertion {
        if (assertions.size() == 0) {
            RMDeliveryAssuranceConfig deliveryMD = new RMDeliveryAssuranceConfig();
            deliveryMD.setInOrder(FALSE);
            deliveryMD.setQuality("AtLeastOnce");
            return deliveryMD;
        }
        if (assertions.size() == 1) {
            QName assertionQN = assertions.get(0).getName();
            RM11PolicyAssertionDeployer.assertIsWSRMPAssertion(assertionQN);
            RMDeliveryAssuranceConfig deliveryMD = new RMDeliveryAssuranceConfig();
            deliveryMD.setInOrder(FALSE);
            deliveryMD.setQuality(assertionQN.getLocalPart());
            return deliveryMD;
        }
        if (assertions.size() == 2) {
            QName firstAssertionQN = assertions.get(0).getName();
            RM11PolicyAssertionDeployer.assertIsWSRMPAssertion(firstAssertionQN);
            QName secondAssertionQN = assertions.get(1).getName();
            RM11PolicyAssertionDeployer.assertIsWSRMPAssertion(secondAssertionQN);
            boolean firstIsInOrder = firstAssertionQN.equals(IN_ORDER);
            RMDeliveryAssuranceConfig deliveryMD = new RMDeliveryAssuranceConfig();
            deliveryMD.setInOrder(TRUE);
            if (firstIsInOrder) {
                deliveryMD.setQuality(secondAssertionQN.getLocalPart());
            } else {
                deliveryMD.setQuality(firstAssertionQN.getLocalPart());
            }
            return deliveryMD;
        }
        throw new IllegalArgumentException();
    }

    private static void assertIsWSRMPAssertion(QName assertionQN) throws UnsupportedAssertion {
        if (assertionQN.equals(EXACTLY_ONCE) || assertionQN.equals(AT_LEAST_ONCE) || assertionQN.equals(AT_MOST_ONCE) || assertionQN.equals(IN_ORDER)) {
            return;
        }
        throw new UnsupportedAssertion();
    }

    private static List<PrimitiveAssertion> getWSRMPAssertions(PrimitiveAssertion assertion) {
        LinkedList<PrimitiveAssertion> retVal = new LinkedList<PrimitiveAssertion>();
        if (assertion.getTerms().size() != 0) {
            Policy policy = (Policy)assertion.getTerms().get(0);
            XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
            AndCompositeAssertion and = (AndCompositeAssertion)xor.getTerms().get(0);
            List primitiveAssertions = and.getTerms();
            for (int i = 0; i < primitiveAssertions.size(); ++i) {
                retVal.add((PrimitiveAssertion)primitiveAssertions.get(i));
            }
        }
        return retVal;
    }
}

