/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util.reference;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentReference {
    public static final int REFERENCE_WEAK = 1;
    public static final int REFERENCE_SOFT = 2;
    private WeakReference<Class<?>> classReference;
    private Reference<Object> referencedObject;
    private int referenceType = 0;

    public PersistentReference(Class<?> clazz, Object referencedObject, int referenceType) {
        this.referenceType = referenceType;
        if (clazz != null) {
            this.classReference = new WeakReference(clazz);
        }
        this.buildReference(referencedObject);
    }

    protected Object internalGet() {
        if (this.referencedObject == null) {
            return null;
        }
        return this.referencedObject.get();
    }

    public Object get() {
        if (this.referencedObject == null) {
            return null;
        }
        Object returnValue = this.referencedObject.get();
        if (returnValue == null) {
            try {
                return this.rebuildReference();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return returnValue;
    }

    public abstract Object rebuildReference() throws Exception;

    public void buildReference(Object obj) {
        this.referencedObject = obj == null ? null : (this.referenceType == 1 ? new WeakReference<Object>(obj) : new SoftReference<Object>(obj));
    }

    public Class<?> getMappedClass() {
        if (this.classReference == null) {
            return null;
        }
        Class returnClass = (Class)this.classReference.get();
        if (returnClass == null) {
            throw new RuntimeException("Class was already unloaded");
        }
        return returnClass;
    }
}

