/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.jcr.ext.replication.ChangesFile;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingBinaryFile {
    private static Log log = ExoLogger.getLogger("ext.PendingBinaryFile");
    private HashMap<String, HashMap<String, ChangesFile>> mapFilePerOwner = new HashMap();
    private long needTransferCounter = 0L;
    private long successfulTransferCounter = 0L;
    private long removedOldChangesLogCounter = 0L;
    private boolean isSuccessfulTransfer = false;
    private boolean isSuccessfulSave = false;

    public ChangesFile addChangesFile(String ownerName, String fileName, String systemId, long totalPacketCount) throws IOException {
        HashMap<Object, Object> fileMap;
        File f = File.createTempFile(fileName, "");
        ChangesFile fileDescriptor = new ChangesFile(f, systemId, totalPacketCount);
        if (!this.mapFilePerOwner.containsKey(ownerName)) {
            fileMap = new HashMap();
            this.mapFilePerOwner.put(ownerName, fileMap);
        } else {
            fileMap = this.mapFilePerOwner.get(ownerName);
        }
        fileMap.put(fileName, fileDescriptor);
        return fileDescriptor;
    }

    public ChangesFile getChangesFile(String ownName, String fileName) {
        if (this.mapFilePerOwner.containsKey(ownName)) {
            HashMap<String, ChangesFile> fileMap = this.mapFilePerOwner.get(ownName);
            return fileMap.get(fileName);
        }
        return null;
    }

    public List<ChangesFile> getSortedFilesDescriptorList() {
        ArrayList<ChangesFile> fileDescriptorhList = new ArrayList<ChangesFile>();
        for (String ownerName : this.mapFilePerOwner.keySet()) {
            HashMap<String, ChangesFile> fileMap = this.mapFilePerOwner.get(ownerName);
            fileDescriptorhList.addAll(fileMap.values());
        }
        if (log.isDebugEnabled()) {
            log.debug("getSortedFilePath() : " + fileDescriptorhList.size());
        }
        Collections.sort(fileDescriptorhList);
        if (log.isDebugEnabled()) {
            log.debug("\n\nList has been sorted :\n");
            for (ChangesFile fd : fileDescriptorhList) {
                log.debug(fd.getFile().getAbsolutePath());
            }
        }
        return fileDescriptorhList;
    }

    public List<String> getFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String ownerName : this.mapFilePerOwner.keySet()) {
            HashMap<String, ChangesFile> fileMap = this.mapFilePerOwner.get(ownerName);
            for (String fileName : fileMap.keySet()) {
                list.add(fileName);
            }
        }
        return list;
    }

    public long getNeedTransferCounter() {
        return this.needTransferCounter;
    }

    public void setNeedTransferCounter(long needTransferCounter) {
        this.needTransferCounter = needTransferCounter;
    }

    public long getRemovedOldChangesLogCounter() {
        return this.removedOldChangesLogCounter;
    }

    public void setRemovedOldChangesLogCounter(long needRemoveOldChangesLogCounter) {
        this.removedOldChangesLogCounter = needRemoveOldChangesLogCounter;
    }

    public boolean isAllOldChangesLogsRemoved() {
        return this.needTransferCounter == this.removedOldChangesLogCounter;
    }

    public long getSuccessfulTransferCounter() {
        return this.successfulTransferCounter;
    }

    public void setSuccessfulTransferCounter(long successfulTransferCounter) {
        this.successfulTransferCounter = successfulTransferCounter;
    }

    public boolean isSuccessfulTransfer() {
        return this.isSuccessfulTransfer;
    }

    public void addToSuccessfulTransferCounter(long count) {
        this.successfulTransferCounter += count;
        this.isSuccessfulTransfer = this.needTransferCounter == this.successfulTransferCounter;
    }

    public boolean isSuccessfulSave() {
        return this.isSuccessfulSave;
    }

    public void setSuccessfulSave(boolean successfulSave) {
        this.isSuccessfulSave = successfulSave;
    }
}

