/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.combine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;

public class OnlyOneApplicablePolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable";
    private static URI identifierURI = URI.create("urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:only-one-applicable");

    public OnlyOneApplicablePolicyAlg() {
        super(identifierURI);
    }

    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        boolean atLeastOne = false;
        AbstractPolicy selectedPolicy = null;
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                return new Result(2, match.getStatus(), context.getResourceId().encode());
            }
            if (result != 0) continue;
            if (atLeastOne) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                String message = "Too many applicable policies";
                return new Result(2, new Status(code, message), context.getResourceId().encode());
            }
            atLeastOne = true;
            selectedPolicy = policy;
        }
        if (atLeastOne) {
            return selectedPolicy.evaluate(context);
        }
        return new Result(3, context.getResourceId().encode());
    }
}

