/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.server.Unreferenced;
import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.rmi.ClientListenerHolder;
import org.jboss.mx.remoting.rmi.ClientNotificationProxy;

public class RMIConnectionImpl
implements RMIConnection,
Unreferenced {
    private RMIServerImpl rmiServer;
    private String connectionId;
    private ClassLoader defaultClassLoader;
    private Subject subject;
    private Map environment;
    private ClientNotificationProxy notificationProxy;
    protected static Logger log = Logger.getLogger((String)RMIConnectionImpl.class.getName());

    public RMIConnectionImpl(RMIServerImpl rmiServer, String connectionId, ClassLoader defaultClassLoader, Subject subject, Map env) {
        this.rmiServer = rmiServer;
        this.connectionId = connectionId;
        this.defaultClassLoader = defaultClassLoader;
        this.subject = subject;
        this.environment = env != null ? env : new HashMap();
        this.notificationProxy = new ClientNotificationProxy();
    }

    public String getConnectionId() throws IOException {
        return this.connectionId;
    }

    public void close() throws IOException {
        ClientListenerHolder[] holders = this.notificationProxy.getListeners();
        if (holders != null) {
            for (int x = 0; x < holders.length; ++x) {
                ClientListenerHolder holder = holders[x];
                try {
                    this.rmiServer.getMBeanServer().removeNotificationListener(holder.getObjectName(), this.notificationProxy, holder.getFilter(), holder.getHandback());
                    continue;
                }
                catch (InstanceNotFoundException e) {
                    log.debug((Object)("Could not remove listener for target mbean " + holder.getObjectName() + " as instance is not found."));
                    continue;
                }
                catch (ListenerNotFoundException e) {
                    log.debug((Object)("Could not remove listener for target mbean " + holder.getObjectName() + " as listener is not found."));
                }
            }
        }
        this.rmiServer.clientClosed(this);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        return this.rmiServer.getMBeanServer().createMBean(className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().createMBean(className, name, loaderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadMarshalledObject(ClassLoader classLoaderReposWrapper, MarshalledObject params) throws IOException {
        Object arg;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (classLoaderReposWrapper != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoaderReposWrapper);
                arg = params.get();
            }
            catch (ClassNotFoundException e) {
                Thread.currentThread().setContextClassLoader(this.defaultClassLoader);
                try {
                    arg = params.get();
                }
                catch (ClassNotFoundException e1) {
                    throw new IOException(e1.getMessage());
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        } else {
            try {
                Thread.currentThread().setContextClassLoader(this.defaultClassLoader);
                arg = params.get();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException(cnfe.getMessage());
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        return arg;
    }

    public ObjectInstance createMBean(String className, ObjectName name, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ClassLoaderRepository classLoaderRepos = this.rmiServer.getMBeanServer().getClassLoaderRepository();
        ClassLoaderRepositoryWrapper classLoaderReposWrapper = new ClassLoaderRepositoryWrapper(classLoaderRepos);
        Object arg = this.loadMarshalledObject(classLoaderReposWrapper, params);
        Object[] args = new Object[]{arg};
        return this.rmiServer.getMBeanServer().createMBean(className, name, args, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, MarshalledObject params, String[] signature, Subject delegationSubject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ClassLoader mbeanSvrClassLoader = this.rmiServer.getMBeanServer().getClassLoader(loaderName);
        Object arg = this.loadMarshalledObject(mbeanSvrClassLoader, params);
        Object[] args = new Object[]{arg};
        return this.rmiServer.getMBeanServer().createMBean(className, name, loaderName, args, signature);
    }

    public void unregisterMBean(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        this.rmiServer.getMBeanServer().unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        QueryExp filter = (QueryExp)this.loadMarshalledObject(query);
        return this.rmiServer.getMBeanServer().queryMBeans(name, filter);
    }

    private Object loadMarshalledObject(MarshalledObject object) throws IOException {
        return this.loadMarshalledObject(null, object);
    }

    public Set queryNames(ObjectName name, MarshalledObject query, Subject delegationSubject) throws IOException {
        QueryExp filter = (QueryExp)this.loadMarshalledObject(query);
        return this.rmiServer.getMBeanServer().queryNames(name, filter);
    }

    public boolean isRegistered(ObjectName name, Subject delegationSubject) throws IOException {
        return this.rmiServer.getMBeanServer().isRegistered(name);
    }

    public Integer getMBeanCount(Subject delegationSubject) throws IOException {
        return this.rmiServer.getMBeanServer().getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute, Subject delegationSubject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.rmiServer.getMBeanServer().getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        return this.rmiServer.getMBeanServer().getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, MarshalledObject attribute, Subject delegationSubject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
        Attribute attrib = (Attribute)this.loadMarshalledObject(mbeanLoader, attribute);
        this.rmiServer.getMBeanServer().setAttribute(name, attrib);
    }

    public AttributeList setAttributes(ObjectName name, MarshalledObject attributes, Subject delegationSubject) throws InstanceNotFoundException, ReflectionException, IOException {
        ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
        AttributeList attrib = (AttributeList)this.loadMarshalledObject(mbeanLoader, attributes);
        return this.rmiServer.getMBeanServer().setAttributes(name, attrib);
    }

    public Object invoke(ObjectName name, String operationName, MarshalledObject params, String[] signature, Subject delegationSubject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
        Object[] args = (Object[])this.loadMarshalledObject(mbeanLoader, params);
        return this.rmiServer.getMBeanServer().invoke(name, operationName, args, signature);
    }

    public String getDefaultDomain(Subject delegationSubject) throws IOException {
        return this.rmiServer.getMBeanServer().getDefaultDomain();
    }

    public String[] getDomains(Subject delegationSubject) throws IOException {
        return this.rmiServer.getMBeanServer().getDomains();
    }

    public MBeanInfo getMBeanInfo(ObjectName name, Subject delegationSubject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.rmiServer.getMBeanServer().getMBeanInfo(name);
    }

    public boolean isInstanceOf(ObjectName name, String className, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        return this.rmiServer.getMBeanServer().isInstanceOf(name, className);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, IOException {
        ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
        NotificationFilter f = (NotificationFilter)this.loadMarshalledObject(mbeanLoader, filter);
        Object o = this.loadMarshalledObject(mbeanLoader, handback);
        this.rmiServer.getMBeanServer().addNotificationListener(name, listener, f, o);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        this.rmiServer.getMBeanServer().removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, MarshalledObject filter, MarshalledObject handback, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
        NotificationFilter f = (NotificationFilter)this.loadMarshalledObject(mbeanLoader, filter);
        Object o = this.loadMarshalledObject(mbeanLoader, handback);
        this.rmiServer.getMBeanServer().removeNotificationListener(name, listener, f, o);
    }

    public Integer[] addNotificationListeners(ObjectName[] names, MarshalledObject[] filters, Subject[] delegationSubjects) throws InstanceNotFoundException, IOException {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("Can not add notification listener without providing target mbean object name.");
        }
        Integer[] ids = new Integer[names.length];
        for (int x = 0; x < names.length; ++x) {
            ObjectName name = names[x];
            MarshalledObject marshalledFilter = filters[x];
            NotificationFilter filter = null;
            if (marshalledFilter != null) {
                ClassLoader mbeanLoader = this.rmiServer.getMBeanServer().getClassLoaderFor(name);
                filter = (NotificationFilter)this.loadMarshalledObject(mbeanLoader, marshalledFilter);
            }
            Integer id = this.notificationProxy.createListenerId(name, filter);
            try {
                this.rmiServer.getMBeanServer().addNotificationListener(name, this.notificationProxy, filter, (Object)id);
            }
            catch (InstanceNotFoundException e) {
                this.notificationProxy.removeListener(id);
                throw e;
            }
            ids[x] = id;
        }
        return ids;
    }

    public void removeNotificationListeners(ObjectName name, Integer[] listenerIDs, Subject delegationSubject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        for (int x = 0; x < listenerIDs.length; ++x) {
            Integer id = listenerIDs[x];
            NotificationFilter filter = this.notificationProxy.removeListener(id);
            this.rmiServer.getMBeanServer().removeNotificationListener(name, this.notificationProxy, filter, (Object)id);
        }
    }

    public NotificationResult fetchNotifications(long clientSequenceNumber, int maxNotifications, long timeout) throws IOException {
        return this.notificationProxy.fetchNotifications(clientSequenceNumber, maxNotifications, timeout);
    }

    public void unreferenced() {
        log.debug((Object)"RMIConnectionImpl::unreferenced called (meaning no client is referencing this connections any longer.  Will close connection.");
        try {
            this.close();
        }
        catch (IOException e) {
            log.error((Object)"Error closing connection due to unreferenced.", (Throwable)e);
        }
    }

    private static class ClassLoaderRepositoryWrapper
    extends SecureClassLoader {
        private final ClassLoaderRepository mbeanSvrRepository;

        private ClassLoaderRepositoryWrapper(ClassLoaderRepository repos) {
            this.mbeanSvrRepository = repos;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.mbeanSvrRepository.loadClass(name);
        }
    }
}

